/*
 * Decompiled with CFR 0.152.
 */
package cn.com.yusys.yusp.commons.filter;

import cn.com.yusys.yusp.commons.dto.Contr;
import cn.com.yusys.yusp.commons.dto.MenuContr;
import cn.com.yusys.yusp.commons.security.SecurityUtils;
import cn.com.yusys.yusp.commons.service.UserService;
import java.io.IOException;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.util.AntPathMatcher;
import org.springframework.web.util.UrlPathHelper;

public class AccessFilter
implements Filter {
    private static final Logger log = LoggerFactory.getLogger(AccessFilter.class);
    private static final int MAX_REFRESH_TIME = 60000;
    private List<? extends Contr> needAuthUrls;
    private AntPathMatcher matcher = new AntPathMatcher();
    private UrlPathHelper pathHelper = new UrlPathHelper();
    @Autowired
    private UserService userCacheService;
    @Value(value="${application.web.ignore-urls}")
    private String ignoreUrlStrs = null;
    @Value(value="${application.web.ignore-resources}")
    private String ignoreResourcesStrs = null;
    private List<String> ignoreUrls;
    private List<String> ignoreResources;
    private long lastRefresh = System.currentTimeMillis();

    public void init(FilterConfig filterConfig) throws ServletException {
        log.info("Create access permission interceptor!");
        if (null == this.ignoreUrlStrs) {
            return;
        }
        this.ignoreUrls = Arrays.asList(this.ignoreUrlStrs.split(",")).stream().map(s -> s.trim()).collect(Collectors.toList());
        if (null == this.ignoreResourcesStrs) {
            return;
        }
        this.ignoreResources = Arrays.asList(this.ignoreResourcesStrs.split(",")).stream().map(s -> s.trim()).collect(Collectors.toList());
    }

    public void doFilter(ServletRequest servletRequest, ServletResponse servletResponse, FilterChain filterChain) throws IOException, ServletException {
        HttpServletRequest request = (HttpServletRequest)servletRequest;
        HttpServletResponse response = (HttpServletResponse)servletResponse;
        String requestUri = this.pathHelper.getLookupPathForRequest(request);
        String accessToken = SecurityUtils.getCurrentUserToken();
        if (log.isDebugEnabled()) {
            log.debug("AccessFilter enter utl:[{}] , ip:[{}:{}]", new Object[]{requestUri, servletRequest.getRemoteAddr(), servletRequest.getRemotePort()});
        }
        boolean isAuthorized = false;
        if (null != this.ignoreUrls) {
            isAuthorized = this.ignoreUrls.stream().anyMatch(ctrl -> this.matcher.matchStart(ctrl, requestUri));
        }
        if (!isAuthorized && null != this.ignoreResources) {
            isAuthorized = this.ignoreResources.stream().anyMatch(ctrl -> requestUri.endsWith((String)ctrl));
        }
        try {
            if (!isAuthorized) {
                if (null == accessToken) {
                    log.error("\u8bf7\u6c42[{}]\u4e2d\u672a\u83b7\u5f97\u7528\u6237\u4fe1\u606f,\u8bf7\u6c42\u672a\u6388\u6743", (Object)requestUri);
                } else {
                    String loginCode = this.userCacheService.getUserCode(accessToken);
                    if (log.isDebugEnabled()) {
                        log.debug("loginCode:[{}];token:[{}]", (Object)loginCode, (Object)accessToken);
                    }
                    if (!StringUtils.isEmpty((CharSequence)loginCode)) {
                        if (this.needAuthUrls == null || System.currentTimeMillis() - this.lastRefresh > 60000L) {
                            this.needAuthUrls = this.userCacheService.findAllContrUrl(accessToken);
                            this.lastRefresh = System.currentTimeMillis();
                        }
                        if (null != this.needAuthUrls && !this.needAuthUrls.isEmpty()) {
                            boolean requestUriNeedAuth = this.needAuthUrls.stream().anyMatch(ctrl -> this.matcher.match(ctrl.getContrUrl(), requestUri));
                            if (requestUriNeedAuth) {
                                MenuContr menucontr = this.userCacheService.getMenuandContr(loginCode, null, accessToken);
                                List contrList = menucontr.getContr();
                                if (contrList != null && contrList.size() > 0) {
                                    isAuthorized = contrList.stream().anyMatch(ctrl -> Objects.nonNull(ctrl.getContrUrl()) && this.matcher.match(ctrl.getContrUrl(), requestUri));
                                }
                            } else {
                                isAuthorized = true;
                            }
                        } else {
                            isAuthorized = true;
                        }
                    }
                }
            }
            if (!isAuthorized) {
                response.sendError(403, "user forbidden from yusp access filter");
            } else {
                filterChain.doFilter(servletRequest, servletResponse);
            }
        }
        catch (Exception e) {
            log.error("AccessFilter exception:[{}]", (Object)e.getMessage());
            e.printStackTrace();
            throw e;
        }
    }

    public void destroy() {
    }
}

