/*
 * Decompiled with CFR 0.152.
 */
package cn.com.yusys.yusp.commons.config;

import cn.com.yusys.yusp.commons.config.ApplicationProperties;
import cn.com.yusys.yusp.commons.util.StringUtil;
import com.google.common.base.Function;
import com.google.common.base.Optional;
import com.google.common.base.Predicate;
import java.nio.ByteBuffer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.context.annotation.Bean;
import org.springframework.http.ResponseEntity;
import org.springframework.util.StopWatch;
import springfox.documentation.builders.PathSelectors;
import springfox.documentation.builders.RequestHandlerSelectors;
import springfox.documentation.service.ApiInfo;
import springfox.documentation.service.Contact;
import springfox.documentation.spi.DocumentationType;
import springfox.documentation.spring.web.plugins.Docket;
import springfox.documentation.swagger2.annotations.EnableSwagger2;

@ConditionalOnClass(value={ApiInfo.class})
@EnableSwagger2
@ConditionalOnProperty(name={"application.swagger.enabled"}, havingValue="true")
public class SwaggerAutoConfiguration {
    private static final Logger log = LoggerFactory.getLogger(SwaggerAutoConfiguration.class);
    @Value(value="${spring.application.name}")
    private String uaaApplication;

    @Bean
    public Docket swaggerSpringfoxDocket(ApplicationProperties applicationProperties) {
        if (log.isDebugEnabled()) {
            log.debug("Starting Swagger");
        }
        StopWatch watch = new StopWatch();
        watch.start();
        Contact contact = new Contact(applicationProperties.getSwagger().getContactName(), applicationProperties.getSwagger().getContactUrl(), applicationProperties.getSwagger().getContactEmail());
        ApiInfo apiInfo = new ApiInfo(applicationProperties.getSwagger().getTitle(), applicationProperties.getSwagger().getDescription(), applicationProperties.getSwagger().getVersion(), applicationProperties.getSwagger().getTermsOfServiceUrl(), contact, applicationProperties.getSwagger().getLicense(), applicationProperties.getSwagger().getLicenseUrl());
        Docket docket = new Docket(DocumentationType.SWAGGER_2).apiInfo(apiInfo).forCodeGeneration(true).directModelSubstitute(ByteBuffer.class, String.class).genericModelSubstitutes(new Class[]{ResponseEntity.class}).select().apis(RequestHandlerSelectors.any()).paths(this.regex(StringUtil.concat((String[])new String[]{applicationProperties.getSwagger().getDefaultIncludePattern(), "/oauth/.*"}, (String)";"))).build();
        watch.stop();
        if (log.isDebugEnabled()) {
            log.debug("Started Swagger in {} ms", (Object)watch.getTotalTimeMillis());
        }
        return docket;
    }

    public Predicate<String> regex(String pathPattern) {
        if (!"uaa".equalsIgnoreCase(this.uaaApplication)) {
            return PathSelectors.regex((String)pathPattern.split(";")[0]);
        }
        return input -> (Boolean)SwaggerAutoConfiguration.declaringClass(input).transform(SwaggerAutoConfiguration.handlerPackage(pathPattern)).or((Object)true);
    }

    private static Function<String, Boolean> handlerPackage(String pathPattern) {
        return input -> {
            for (String path : pathPattern.split(";")) {
                boolean isMatch = input.matches(path);
                if (!isMatch) continue;
                return true;
            }
            return false;
        };
    }

    private static Optional<? extends String> declaringClass(String input) {
        return Optional.fromNullable((Object)input);
    }
}

