/*
 * Decompiled with CFR 0.152.
 */
package cn.com.yusys.yusp.commons.config;

import cn.com.yusys.yusp.commons.interceptor.TokenCopyInterceptor;
import feign.Feign;
import java.util.concurrent.TimeUnit;
import okhttp3.ConnectionPool;
import okhttp3.Interceptor;
import okhttp3.OkHttpClient;
import org.springframework.boot.autoconfigure.AutoConfigureBefore;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.cloud.openfeign.FeignAutoConfiguration;
import org.springframework.context.annotation.Bean;

@ConditionalOnClass(value={Feign.class, FeignAutoConfiguration.class, Interceptor.class})
@AutoConfigureBefore(value={FeignAutoConfiguration.class})
@ConditionalOnProperty(value={"feign.okhttp.enabled"})
public class OkHttpAutoConfiguration {
    private int feignOkHttpReadTimeout = 60000;
    private int feignConnectTimeout = 60000;
    private int feignWriteTimeout = 120000;

    @Bean
    public OkHttpClient okHttpClient() {
        return new OkHttpClient.Builder().readTimeout((long)this.feignOkHttpReadTimeout, TimeUnit.SECONDS).connectTimeout((long)this.feignConnectTimeout, TimeUnit.SECONDS).writeTimeout((long)this.feignWriteTimeout, TimeUnit.SECONDS).connectionPool(new ConnectionPool()).addInterceptor((Interceptor)this.tokenCopyInterceptor()).build();
    }

    @Bean
    public TokenCopyInterceptor tokenCopyInterceptor() {
        return new TokenCopyInterceptor();
    }
}

