/*
 * Decompiled with CFR 0.152.
 */
package cn.com.yusys.yusp.commons.config;

import cn.com.yusys.yusp.commons.aop.dataauth.handler.DataAuthParamHander;
import cn.com.yusys.yusp.commons.aop.dataauth.handler.DefaultDataAuthParamHander;
import cn.com.yusys.yusp.commons.config.ApplicationProperties;
import cn.com.yusys.yusp.commons.config.CacheAutoConfiguration;
import cn.com.yusys.yusp.commons.filter.AccessFilter;
import cn.com.yusys.yusp.commons.filter.DataAuthFilter;
import cn.com.yusys.yusp.commons.filter.FileUploadChkFilter;
import cn.com.yusys.yusp.commons.filter.XssAndSQLFilter;
import cn.com.yusys.yusp.commons.service.UserService;
import java.util.EnumSet;
import java.util.List;
import javax.servlet.DispatcherType;
import javax.servlet.Filter;
import org.apache.ibatis.session.SqlSessionFactory;
import org.mybatis.spring.SqlSessionFactoryBean;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.boot.autoconfigure.AutoConfigureAfter;
import org.springframework.boot.autoconfigure.condition.ConditionalOnBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.web.servlet.FilterRegistrationBean;
import org.springframework.boot.web.servlet.ServletRegistrationBean;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.web.cors.CorsConfiguration;
import org.springframework.web.cors.CorsConfigurationSource;
import org.springframework.web.cors.UrlBasedCorsConfigurationSource;
import org.springframework.web.filter.CorsFilter;

@AutoConfigureAfter(value={CacheAutoConfiguration.class})
public class FiltersAutoConfiguration {
    private static final Logger log = LoggerFactory.getLogger(FiltersAutoConfiguration.class);

    @Configuration
    @ConditionalOnProperty(name={"application.filter.access.enabled"}, havingValue="true")
    @ConditionalOnBean(value={UserService.class})
    public class AccessConfiguration {
        private final Logger log = LoggerFactory.getLogger(this.getClass());

        @Bean
        public AccessFilter accessFilter() {
            this.log.info("\u81ea\u52a8\u914d\u7f6e>> \u63a7\u5236\u70b9\u6743\u9650\u6821\u9a8c\u914d\u7f6e\u5b8c\u6210");
            return new AccessFilter();
        }

        @Bean
        public FilterRegistrationBean accessFilterBean() {
            FilterRegistrationBean bean = new FilterRegistrationBean((Filter)this.accessFilter(), new ServletRegistrationBean[0]);
            bean.setOrder(0x7FFFFF37);
            return bean;
        }
    }

    @Configuration
    @ConditionalOnProperty(name={"application.filter.dataauth.enabled"}, matchIfMissing=false)
    @ConditionalOnClass(value={SqlSessionFactory.class, SqlSessionFactoryBean.class})
    @ConditionalOnBean(value={UserService.class})
    public class DataAuthAutoConfiguration {
        private final Logger log = LoggerFactory.getLogger(this.getClass());

        @Bean
        public DataAuthFilter dataAuthFilter() {
            this.log.info("\u81ea\u52a8\u914d\u7f6e>> \u8bb0\u5f55\u96c6\u6743\u9650\u8fc7\u6ee4\u5668\u914d\u7f6e\u5b8c\u6210");
            return new DataAuthFilter();
        }

        @Bean
        public FilterRegistrationBean dataAuthFilterBean() {
            FilterRegistrationBean bean = new FilterRegistrationBean((Filter)this.dataAuthFilter(), new ServletRegistrationBean[0]);
            bean.setOrder(2147483546);
            return bean;
        }

        @Bean
        @ConditionalOnMissingBean
        public DataAuthParamHander dataAuthParamHander() {
            return new DefaultDataAuthParamHander();
        }
    }

    @Configuration
    @ConditionalOnProperty(name={"application.filter.cors.enabled"}, havingValue="true")
    @ConditionalOnMissingBean(value={CorsFilter.class})
    public class CorsAutoConfiguration {
        private final Logger log = LoggerFactory.getLogger(this.getClass());
        private final ApplicationProperties properties;

        public CorsAutoConfiguration(ApplicationProperties properties) {
            this.properties = properties;
        }

        @Bean
        public CorsFilter corsFilter() {
            UrlBasedCorsConfigurationSource source = new UrlBasedCorsConfigurationSource();
            CorsConfiguration config = this.properties.getCors();
            if (config.getAllowedOrigins() != null && !config.getAllowedOrigins().isEmpty()) {
                source.registerCorsConfiguration("/api/**", config);
                source.registerCorsConfiguration("/v2/api-docs", config);
                source.registerCorsConfiguration("/oauth/**", config);
            }
            return new CorsFilter((CorsConfigurationSource)source);
        }

        @Bean
        public FilterRegistrationBean corsFilterBean() {
            FilterRegistrationBean bean = new FilterRegistrationBean((Filter)this.corsFilter(), new ServletRegistrationBean[0]);
            bean.setOrder(Integer.MIN_VALUE);
            this.log.info("\u81ea\u52a8\u914d\u7f6e>> \u8de8\u57df\u914d\u7f6e\u5b8c\u6210 -> order [{}]", (Object)Integer.MIN_VALUE);
            return bean;
        }
    }

    @Configuration
    @ConditionalOnProperty(name={"application.filter.fileupload.enabled"}, havingValue="true")
    public class FileChkAutoConfiguration {
        @Value(value="${application.filter.fileupload.access-file-type:null}")
        private List<String> accessFileType = null;

        @Bean
        public FileUploadChkFilter fileUploadFilter() {
            log.info("\u81ea\u52a8\u914d\u7f6e>> \u9632\u6076\u610f\u6587\u4ef6\u4e0a\u4f20\u8fc7\u6ee4\u5668\u914d\u7f6e\u5b8c\u6210");
            return new FileUploadChkFilter(this.accessFileType);
        }
    }

    @Configuration
    @ConditionalOnProperty(name={"application.filter.xss.enabled"}, havingValue="true")
    public class XSSAndSqlAutoConfiguration {
        @Bean
        public FilterRegistrationBean xssAndSqlFilter() {
            FilterRegistrationBean registration = new FilterRegistrationBean();
            registration.setFilter((Filter)new XssAndSQLFilter());
            registration.addUrlPatterns(new String[]{"/*"});
            EnumSet<DispatcherType> dispatcherTypes = EnumSet.of(DispatcherType.REQUEST, DispatcherType.FORWARD, DispatcherType.ASYNC);
            registration.setDispatcherTypes(dispatcherTypes);
            log.info("\u81ea\u52a8\u914d\u7f6e>> \u9632Xss\u653b\u51fb  SQL\u6ce8\u5165 \u8fc7\u6ee4\u5668\u914d\u7f6e\u5b8c\u6210");
            return registration;
        }
    }
}

