/*
 * Decompiled with CFR 0.152.
 */
package cn.com.yusys.yusp.commons.config;

import java.time.Duration;
import java.util.LinkedHashMap;
import java.util.Map;
import org.springframework.beans.factory.NoSuchBeanDefinitionException;
import org.springframework.boot.actuate.health.CompositeHealthIndicatorFactory;
import org.springframework.boot.actuate.health.Health;
import org.springframework.boot.actuate.health.HealthAggregator;
import org.springframework.boot.actuate.health.HealthIndicator;
import org.springframework.boot.actuate.health.OrderedHealthAggregator;
import org.springframework.boot.actuate.health.ReactiveHealthIndicator;
import org.springframework.context.ApplicationContext;
import org.springframework.util.ClassUtils;

public class CustomHealthIndicatorBeansComposite {
    private CustomHealthIndicatorBeansComposite() {
    }

    public static HealthIndicator get(ApplicationContext applicationContext) {
        HealthAggregator healthAggregator = CustomHealthIndicatorBeansComposite.getHealthAggregator(applicationContext);
        LinkedHashMap indicators = new LinkedHashMap();
        indicators.putAll(applicationContext.getBeansOfType(HealthIndicator.class));
        if (ClassUtils.isPresent((String)"reactor.core.publisher.Flux", null)) {
            new ReactiveHealthIndicatorsAdaptor().get(applicationContext).forEach(indicators::putIfAbsent);
        }
        CompositeHealthIndicatorFactory factory = new CompositeHealthIndicatorFactory();
        return factory.createHealthIndicator(healthAggregator, indicators);
    }

    private static HealthAggregator getHealthAggregator(ApplicationContext applicationContext) {
        try {
            return (HealthAggregator)applicationContext.getBean(HealthAggregator.class);
        }
        catch (NoSuchBeanDefinitionException ex) {
            return new OrderedHealthAggregator();
        }
    }

    private static class ReactiveHealthIndicatorsAdaptor {
        private ReactiveHealthIndicatorsAdaptor() {
        }

        public Map<String, HealthIndicator> get(ApplicationContext applicationContext) {
            LinkedHashMap<String, HealthIndicator> indicators = new LinkedHashMap<String, HealthIndicator>();
            applicationContext.getBeansOfType(ReactiveHealthIndicator.class).forEach((name, indicator) -> indicators.put((String)name, this.adapt((ReactiveHealthIndicator)indicator)));
            return indicators;
        }

        private HealthIndicator adapt(ReactiveHealthIndicator indicator) {
            return () -> {
                Health res = null;
                try {
                    res = (Health)indicator.health().block(Duration.ofMillis(1000L));
                }
                catch (Exception ex) {
                    res = new Health.Builder().down((Throwable)ex).build();
                }
                return res;
            };
        }
    }
}

