/*
 * Decompiled with CFR 0.152.
 */
package cn.com.yusys.yusp.common.util;

import java.lang.annotation.Annotation;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import javax.persistence.Entity;

public class BeanUtil {
    public static <T> List<Field> findAllFields(Class<T> clazz) {
        Field[] declaredFields = clazz.getDeclaredFields();
        List<Field> declaredFieldList = Arrays.asList(declaredFields);
        ArrayList<Field> allFieldList = new ArrayList<Field>();
        allFieldList.addAll(declaredFieldList);
        return allFieldList;
    }

    public static <T> Field findFieldWithParent(Class<T> clazz, String fieldName) {
        Field field = null;
        Class<T> cClazz = clazz;
        while (field == null && cClazz != null) {
            try {
                field = cClazz.getDeclaredField(fieldName);
            }
            catch (NoSuchFieldException var5) {
                field = null;
            }
            if (field != null) continue;
            Class<T> superClass = cClazz.getSuperclass();
            if (superClass == null || superClass.equals(Object.class) || !superClass.isAnnotationPresent(Entity.class) && (Map.class.isAssignableFrom(superClass) || Collection.class.isAssignableFrom(superClass))) {
                cClazz = null;
                continue;
            }
            cClazz = superClass;
        }
        return field;
    }

    public static <A extends Annotation> A findAnnotation(Field field, Class<A> annotationClass) {
        return field.getAnnotation(annotationClass);
    }

    public static <T> void setFieldValue(T target, Field field, Object value) {
        try {
            String fieldName = field.getName();
            Method method = null;
            try {
                method = target.getClass().getMethod("set" + fieldName.substring(0, 1).toUpperCase() + fieldName.substring(1), field.getType());
            }
            catch (NoSuchMethodException var6) {
                method = null;
            }
            catch (SecurityException var7) {
                method = null;
            }
            Object setValue = BeanUtil.convertFieldValue(field, value);
            if (method == null) {
                if (!Modifier.isPublic(field.getModifiers())) {
                    throw new RuntimeException("Property [" + field + "] is not public or does not have a public setter method");
                }
                field.set(target, setValue);
            } else if (setValue != null || !field.getType().isPrimitive()) {
                method.invoke(target, setValue);
            }
        }
        catch (Exception var8) {
            throw new RuntimeException("Property assignment error", var8);
        }
    }

    public static Object getFieldValue(Field field, Object object) {
        try {
            String fieldName = field.getName();
            Method method = null;
            try {
                method = object.getClass().getMethod("get" + fieldName.substring(0, 1).toUpperCase() + fieldName.substring(1), new Class[0]);
            }
            catch (NoSuchMethodException var5) {
                method = null;
            }
            catch (SecurityException var6) {
                method = null;
            }
            if (method == null) {
                if (Modifier.isPublic(field.getModifiers())) {
                    return field.get(object);
                }
                throw new RuntimeException("Property [" + field + "] is not public or does not have a public getter method");
            }
            Object value = method.invoke(object, new Object[0]);
            return value;
        }
        catch (Exception var7) {
            throw new RuntimeException("Property get value error", var7);
        }
    }

    public static Object convertFieldValue(Field field, Object value) {
        Class<?> targetClass = field.getType();
        if (value == null) {
            return value;
        }
        if (targetClass.isInstance(value)) {
            return value;
        }
        if (String.class == targetClass) {
            return value.toString();
        }
        if ("".equals(value.toString().trim())) {
            return null;
        }
        if (Boolean.class != targetClass && !targetClass.getName().equalsIgnoreCase("boolean")) {
            if (Character.class != targetClass && !targetClass.getName().equalsIgnoreCase("char")) {
                if (Byte.class != targetClass && !targetClass.getName().equalsIgnoreCase("Byte")) {
                    if (Short.class != targetClass && !targetClass.getName().equalsIgnoreCase("Short")) {
                        if (Integer.class != targetClass && !targetClass.getName().equalsIgnoreCase("Integer")) {
                            if (Long.class != targetClass && !targetClass.getName().equalsIgnoreCase("Long")) {
                                if (BigInteger.class == targetClass) {
                                    return BigInteger.valueOf(Long.valueOf(value.toString()));
                                }
                                if (Float.class != targetClass && !targetClass.getName().equalsIgnoreCase("Float")) {
                                    if (Double.class != targetClass && !targetClass.getName().equalsIgnoreCase("Double")) {
                                        if (BigDecimal.class == targetClass) {
                                            return new BigDecimal(value.toString());
                                        }
                                        throw new RuntimeException(value.getClass() + " convert to " + targetClass + " is not supported");
                                    }
                                    return Double.valueOf(value.toString());
                                }
                                return Float.valueOf(value.toString());
                            }
                            return Long.valueOf(value.toString());
                        }
                        return Integer.valueOf(value.toString());
                    }
                    return Short.valueOf(value.toString());
                }
                return Byte.valueOf(value.toString());
            }
            return Character.valueOf(value.toString().charAt(0));
        }
        return Boolean.valueOf(value.toString());
    }

    public static String convertFieldValueToStr(Field field, Object value) {
        Class<?> targetClass = field.getType();
        if (value == null) {
            return "";
        }
        if (String.class == targetClass) {
            return value.toString();
        }
        if ("".equals(value.toString().trim())) {
            return "";
        }
        if (Boolean.class != targetClass && !targetClass.getName().equalsIgnoreCase("boolean")) {
            if (Character.class != targetClass && !targetClass.getName().equalsIgnoreCase("char")) {
                if (Byte.class != targetClass && !targetClass.getName().equalsIgnoreCase("Byte")) {
                    if (Short.class != targetClass && !targetClass.getName().equalsIgnoreCase("Short")) {
                        if (Integer.class != targetClass && !targetClass.getName().equalsIgnoreCase("Integer")) {
                            if (Long.class != targetClass && !targetClass.getName().equalsIgnoreCase("Long")) {
                                if (BigInteger.class == targetClass) {
                                    return ((BigInteger)value).toString(10);
                                }
                                if (Float.class != targetClass && !targetClass.getName().equalsIgnoreCase("Float")) {
                                    if (Double.class != targetClass && !targetClass.getName().equalsIgnoreCase("Double")) {
                                        if (BigDecimal.class == targetClass) {
                                            return value.toString();
                                        }
                                        throw new RuntimeException(value.getClass() + " convert to " + targetClass + " is not supported");
                                    }
                                    return String.valueOf(value);
                                }
                                return String.valueOf(value);
                            }
                            return String.valueOf(value);
                        }
                        return String.valueOf(value);
                    }
                    return String.valueOf(value);
                }
                byte[] valueT = (byte[])value;
                return new String(valueT);
            }
            return String.valueOf(value);
        }
        return String.valueOf(value);
    }
}

