/*
 * Decompiled with CFR 0.152.
 */
package cn.com.yusys.yusp.common.annotation;

import cn.com.yusys.yusp.common.dto.IcspResultDto;
import cn.com.yusys.yusp.common.log.LogTradeBussFeign;
import cn.com.yusys.yusp.common.log.domain.LogTradeBussBo;
import cn.com.yusys.yusp.common.req.IcspRequest;
import cn.com.yusys.yusp.commons.util.StringUtils;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Map;
import org.aspectj.lang.ProceedingJoinPoint;
import org.aspectj.lang.annotation.Around;
import org.aspectj.lang.annotation.Aspect;
import org.aspectj.lang.annotation.Pointcut;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Aspect
@Component
public class TradeBussLogAspect {
    private static final Logger logger = LoggerFactory.getLogger(TradeBussLogAspect.class);
    @Autowired
    private LogTradeBussFeign logTradeBussFeign;

    @Pointcut(value="@annotation(TradeBussLog)")
    private void cutMethod() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Around(value="cutMethod()")
    public void aroundMethod(ProceedingJoinPoint point) throws Throwable {
        LogTradeBussBo logTradeBussBo = null;
        long startTime = 0L;
        Object result = null;
        try {
            result = point.proceed();
        }
        finally {
            Object[] args = point.getArgs();
            IcspRequest request = (IcspRequest)args[0];
            logTradeBussBo = this.evaluateObject(request);
            if (result != null && result instanceof IcspResultDto) {
                IcspResultDto icspResultDto = (IcspResultDto)result;
                logTradeBussBo.setRespCode(icspResultDto.getHead().getResponseCode());
                logTradeBussBo.setRespMessage(icspResultDto.getHead().getResponseMes());
            } else {
                logTradeBussBo.setRespCode("9999");
                logTradeBussBo.setRespMessage("\u8c03\u7528\u4ea4\u6613\u63a5\u53e3\u5931\u8d25");
            }
            IcspRequest<LogTradeBussBo> icspRequest = new IcspRequest<LogTradeBussBo>();
            icspRequest.setBody(logTradeBussBo);
            this.logTradeBussFeign.create(icspRequest);
        }
    }

    private LogTradeBussBo evaluateObject(IcspRequest request) {
        LogTradeBussBo logTradeBussBo = new LogTradeBussBo();
        String yyyyMMddSSmmssSSS = new SimpleDateFormat("yyyyMMddHHmmssSSS").format(new Date()).toString();
        String yyyyMMdd = yyyyMMddSSmmssSSS.substring(0, 8);
        String hhmmssSSS = yyyyMMddSSmmssSSS.substring(8, 17);
        logTradeBussBo.setLogId(StringUtils.getUUID());
        logTradeBussBo.setGlobalSeq(request.getSysHead().getGlobalSeq());
        logTradeBussBo.setCustSeq(request.getTradeHead().getCustSerialNo());
        logTradeBussBo.setTradeSeq(request.getTradeHead().getTradeSerialNo());
        logTradeBussBo.setWorkDate(request.getTradeHead().getWorkDate());
        logTradeBussBo.setReqChannel(request.getSysHead().getChannel());
        logTradeBussBo.setReqChannelSeq(request.getSysHead().getChannelSeq());
        logTradeBussBo.setOrgId(request.getTradeHead().getOrgId());
        logTradeBussBo.setTradeCode(request.getTradeHead().getTradeCode());
        logTradeBussBo.setTradeName(request.getTradeHead().getTradeName());
        logTradeBussBo.setServerDate(yyyyMMdd);
        logTradeBussBo.setServerTime(hhmmssSSS);
        Map requestBody = (Map)request.getBody();
        logTradeBussBo.setPayAccountNo((String)requestBody.get("payAccountNo"));
        logTradeBussBo.setDbtAccountNo((String)requestBody.get("dbtAccountNo"));
        logTradeBussBo.setCreditAccountNo((String)requestBody.get("creditAccountNo"));
        logTradeBussBo.setCcy(request.getTradeHead().getCcy());
        logTradeBussBo.setAmt(Double.parseDouble(request.getTradeHead().getAmt()));
        logTradeBussBo.setVouType((String)requestBody.get("vouType"));
        logTradeBussBo.setVouNo((String)requestBody.get("vouNo"));
        logTradeBussBo.setChkSeq((String)requestBody.get("chkSeq"));
        logTradeBussBo.setChkRslt((String)requestBody.get("chkRslt"));
        logTradeBussBo.setChkFlag((String)requestBody.get("chkFlag"));
        logTradeBussBo.setTradeSts((String)requestBody.get("tradeSts"));
        logTradeBussBo.setIsCashFlag((String)requestBody.get("isCashFlag"));
        logTradeBussBo.setTradeType(request.getTradeHead().getTradeType());
        logTradeBussBo.setTradeCls((String)requestBody.get("tradeCls"));
        logTradeBussBo.setTradeMode((String)requestBody.get("tradeMode"));
        logTradeBussBo.setAuthSeq((String)requestBody.get("authSeq"));
        logTradeBussBo.setAuthTeller((String)requestBody.get("authTeller"));
        logTradeBussBo.setReviewSeq((String)requestBody.get("reviewSeq"));
        logTradeBussBo.setReviewTeller((String)requestBody.get("reviewTeller"));
        logTradeBussBo.setTransTeller((String)requestBody.get("transTeller"));
        logTradeBussBo.setRemark((String)requestBody.get("remark"));
        logTradeBussBo.setAgtCertType((String)requestBody.get("agtCertType"));
        logTradeBussBo.setAgtCertId((String)requestBody.get("agtCertId"));
        logTradeBussBo.setAgtName((String)requestBody.get("agtName"));
        logTradeBussBo.setAgtTel((String)requestBody.get("agtTel"));
        logTradeBussBo.setIsSubmitFlag((String)requestBody.get("isSubmitFlag"));
        return logTradeBussBo;
    }
}

