/*
 * Decompiled with CFR 0.152.
 */
package cn.com.yusys.yusp.admin.service;

import cn.com.yusys.yusp.admin.service.AdminSmLookupItemClient;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.cache.annotation.Cacheable;
import org.springframework.stereotype.Service;

@Service
public class AdminSmLookupItemCacheService {
    private final Logger log = LoggerFactory.getLogger(AdminSmLookupItemCacheService.class);
    @Autowired
    private AdminSmLookupItemClient adminSmLookupItemClient;

    @Cacheable(value={"AdminSmLookupItem"}, key="#lookupCode", unless="#result == null")
    public Map<String, List<Map<String, String>>> getLookupCodeCacheList(String lookupCode) {
        HashMap<String, List<Map<String, String>>> map = new HashMap<String, List<Map<String, String>>>();
        ArrayList list = new ArrayList();
        List<String> itemList = this.adminSmLookupItemClient.getLookupItemCode(lookupCode);
        if (itemList.isEmpty()) {
            this.log.info("\u4e0d\u5b58\u5728" + lookupCode + "\u8be5\u5b57\u5178\u9879\uff0c\u6216\u8be5\u5b57\u5178\u9879\u672a\u914d\u7f6e");
            return null;
        }
        for (String str : itemList) {
            HashMap<String, String> itemMap = new HashMap<String, String>();
            String itemName = this.adminSmLookupItemClient.getLookupItemName(lookupCode, str);
            itemMap.put("key", str);
            itemMap.put("value", itemName);
            list.add(itemMap);
        }
        map.put(lookupCode, list);
        return map;
    }
}

