/*
 * Decompiled with CFR 0.152.
 */
package cn.com.yusys.yusp.admin.validation.ext;

import cn.com.yusys.yusp.admin.service.AdminSmLookupItemCacheService;
import cn.com.yusys.yusp.admin.service.AdminSmLookupItemClient;
import cn.com.yusys.yusp.admin.validation.InDataCode;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import javax.validation.ConstraintValidator;
import javax.validation.ConstraintValidatorContext;
import org.springframework.beans.factory.annotation.Autowired;

public class InDataCodeValidator
implements ConstraintValidator<InDataCode, String> {
    private String dataCode;
    @Autowired
    private AdminSmLookupItemClient adminSmLookupItemClient;
    @Autowired
    AdminSmLookupItemCacheService adminSmLookupItemCacheService;

    public void initialize(InDataCode constraintAnnotation) {
        this.dataCode = constraintAnnotation.dataCode();
    }

    public boolean isValid(String value, ConstraintValidatorContext context) {
        if (null == value || "".equals(value)) {
            return true;
        }
        List<Object> codes = new ArrayList();
        Map<String, List<Map<String, String>>> LookupCodeMap = this.adminSmLookupItemCacheService.getLookupCodeCacheList(this.dataCode);
        if (LookupCodeMap != null && LookupCodeMap.containsKey(this.dataCode)) {
            List<Map<String, String>> lookupItem = LookupCodeMap.get(this.dataCode);
            if (lookupItem != null && lookupItem.size() > 0) {
                for (Map<String, String> map : lookupItem) {
                    codes.add(map.get("key"));
                }
            }
        } else {
            codes = this.adminSmLookupItemClient.getLookupItemCode(this.dataCode);
        }
        if (codes == null) {
            context.disableDefaultConstraintViolation();
            context.buildConstraintViolationWithTemplate("\u67e5\u8be2\u6570\u636e\u5b57\u5178\u5f02\u5e38\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458\uff01").addConstraintViolation();
            return false;
        }
        if (codes.size() == 0) {
            context.disableDefaultConstraintViolation();
            context.buildConstraintViolationWithTemplate("\u8be5\u5b57\u6bb5\u5bf9\u5e94\u7684\u6570\u636e\u5b57\u5178\u3010dataCode:" + this.dataCode + "\u3011\u4e0d\u5b58\u5728\uff01").addConstraintViolation();
            return false;
        }
        return codes.contains(value);
    }
}

