/*
 * Decompiled with CFR 0.152.
 */
package cn.com.yusys.yusp.yuin.base.util;

import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.StringWriter;
import java.io.UnsupportedEncodingException;
import java.io.Writer;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.regex.Pattern;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.Marshaller;
import org.dom4j.Document;
import org.dom4j.DocumentException;
import org.dom4j.DocumentHelper;
import org.dom4j.Element;
import org.dom4j.io.OutputFormat;
import org.dom4j.io.SAXReader;
import org.dom4j.io.XMLWriter;

public class XmlUtil {
    private static String defaultEncoding = "UTF-8";

    public static Document getDocument(String filePath, String fileName) throws Exception {
        return XmlUtil.getDocument(filePath + File.separator + fileName);
    }

    public static Document getDocument(String fileName) throws Exception {
        FileInputStream fis = null;
        try {
            fis = new FileInputStream(fileName);
            Document document = XmlUtil.getDocument(fis);
            return document;
        }
        catch (Exception e) {
            throw e;
        }
        finally {
            try {
                if (fis != null) {
                    fis.close();
                }
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }

    public static Document getDocument(InputStream is) throws Exception {
        SAXReader reader = new SAXReader();
        Document document = reader.read(is);
        return document;
    }

    public static Document getDocument(InputStream is, String encoding) throws Exception {
        SAXReader reader = new SAXReader();
        reader.setEncoding(encoding);
        Document document = reader.read(is);
        return document;
    }

    public static Element getElementByName(Element e, String name) {
        Iterator iterator = e.elementIterator(name);
        if (iterator.hasNext()) {
            return (Element)iterator.next();
        }
        return null;
    }

    public static List<Element> getElementsByName(Element e, String name) {
        return e.elements(name);
    }

    public static Element getElementByNameAndAttribute(Element e, String name, String attribute, String value) {
        Iterator iterator = e.elementIterator(name);
        while (iterator.hasNext()) {
            Element element = (Element)iterator.next();
            if (!value.equals(element.attribute(attribute).getValue())) continue;
            return element;
        }
        return null;
    }

    public static String getElementValueByName(Element e, String name) {
        Iterator iterator = e.elementIterator(name);
        if (iterator.hasNext()) {
            return ((Element)iterator.next()).getText();
        }
        return "";
    }

    public static String getElementAttributeByName(Element e, String name, String attribute) {
        Iterator iterator = e.elementIterator(name);
        if (iterator.hasNext()) {
            return ((Element)iterator.next()).attribute(attribute).getValue();
        }
        return "";
    }

    public static String[] getElementValuesByName(Element e, String name) {
        Iterator iterator = e.elementIterator(name);
        StringBuffer buffer = new StringBuffer();
        while (iterator.hasNext()) {
            if ("".equals(buffer.toString())) {
                buffer.append(((Element)iterator.next()).getText());
                continue;
            }
            buffer.append(((Element)iterator.next()).getText() + ",");
        }
        return buffer.toString().split(",");
    }

    public static Document createDocument() {
        Document document = DocumentHelper.createDocument();
        return document;
    }

    public static Element createRootElement(Document document, String rootName) {
        if (document != null) {
            return document.addElement(rootName);
        }
        return null;
    }

    public static Element createElement(Element pElement, String elementName, String elmentText) {
        if (pElement != null) {
            Element nElement = pElement.addElement(elementName);
            if (elmentText != null) {
                nElement.addText(elmentText);
            }
            return nElement;
        }
        return null;
    }

    public static void saveSocketXml(Document document, OutputStream os) {
        XmlUtil.saveSocketXml(document.getRootElement(), os);
    }

    public static void saveSocketXml(Element e, OutputStream os) {
        DataOutputStream dos = new DataOutputStream(os);
        try {
            int len = e.asXML().getBytes("GBK").length;
            dos.writeInt(len);
            dos.write(e.asXML().getBytes("GBK"));
            dos.flush();
        }
        catch (IOException e1) {
            e1.printStackTrace();
        }
    }

    public static Document parseDocumentText(String xmlStr) throws DocumentException {
        Document doc = DocumentHelper.parseText((String)xmlStr);
        return doc;
    }

    public static void main(String[] args) throws DocumentException {
    }

    public static Element parseElementText(String xmlStr) throws DocumentException {
        Document doc = DocumentHelper.parseText((String)("<?xml version=\"1.0\" encoding=\"GBK\"?>\n" + xmlStr));
        return doc.getRootElement();
    }

    public static byte[] readByte(DataInputStream is, int len) throws IOException {
        byte[] b = new byte[len];
        is.readFully(b);
        return b;
    }

    public static void saveXml(Document document, OutputStream os, String encoding) {
        OutputFormat format = OutputFormat.createPrettyPrint();
        format.setEncoding(encoding);
        XMLWriter output = null;
        try {
            output = new XMLWriter(os, format);
            output.write(document);
            output.close();
        }
        catch (UnsupportedEncodingException e) {
            e.printStackTrace();
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public static void saveXml(Document document, OutputStream os) {
        XmlUtil.saveXml(document, os, defaultEncoding);
    }

    public static void saveXml(Element element, OutputStream os) {
        Document document = DocumentHelper.createDocument();
        document.add(element);
        XmlUtil.saveXml(document, os, defaultEncoding);
    }

    public static Object getValue(Object rootObj, String name) throws Exception {
        String[] shortNames = name.split("[.]");
        Object midObj = rootObj;
        for (String shortName : shortNames) {
            if (Pattern.matches("[A-Za-z0-9_]+\\[\\d\\]", shortName)) {
                String keyName = shortName.substring(0, shortName.indexOf("["));
                int index = Integer.parseInt(shortName.substring(shortName.indexOf("[") + 1, shortName.indexOf("]")));
                Map tmpObj = (Map)midObj;
                Object valueObj = tmpObj.get(keyName);
                List tmpList = null;
                if (valueObj instanceof List) {
                    tmpList = (List)valueObj;
                    midObj = tmpList.get(index);
                    continue;
                }
                return null;
            }
            if (Pattern.matches("[A-Za-z0-9_]+", shortName)) {
                Map midMap = (Map)midObj;
                Object tmpObject = midMap.get(shortName);
                if (tmpObject instanceof Map) {
                    midObj = tmpObject;
                    continue;
                }
                if (tmpObject instanceof List) {
                    List tmpObjList = (List)tmpObject;
                    midObj = tmpObjList.get(0);
                    continue;
                }
                if (tmpObject instanceof String) {
                    midObj = tmpObject;
                    continue;
                }
                return null;
            }
            return null;
        }
        return (String)midObj;
    }

    public static String convertToXml(Object obj) {
        return XmlUtil.convertToXml(obj, "UTF-8");
    }

    public static String convertToXml(Object obj, String encoding) {
        String result = null;
        try {
            JAXBContext context = JAXBContext.newInstance((Class[])new Class[]{obj.getClass()});
            Marshaller marshaller = context.createMarshaller();
            marshaller.setProperty("jaxb.formatted.output", (Object)true);
            marshaller.setProperty("jaxb.encoding", (Object)encoding);
            StringWriter writer = new StringWriter();
            marshaller.marshal(obj, (Writer)writer);
            result = writer.toString();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return result;
    }

    public static Map<String, Object> Dom2Map(Element ele) throws Exception {
        HashMap<String, Object> eleMap = new HashMap<String, Object>();
        if (ele.elements().size() > 0) {
            List childEles = ele.elements();
            HashMap<String, Object> children = new HashMap<String, Object>();
            for (int i = 0; i < childEles.size(); ++i) {
                Element childEle = (Element)childEles.get(i);
                Map<String, Object> childMap = XmlUtil.Dom2Map(childEle);
                for (String key : childMap.keySet()) {
                    if (children.containsKey(key)) {
                        List<Object> lists;
                        Object obj = children.get(key);
                        if (obj instanceof Map) {
                            lists = new ArrayList();
                            lists.add(obj);
                            lists.add(childMap.get(key));
                            children.put(key, lists);
                            continue;
                        }
                        if (!(obj instanceof List)) continue;
                        lists = (List)obj;
                        lists.add(childMap.get(key));
                        children.put(key, lists);
                        continue;
                    }
                    children.put(key, childMap.get(key));
                }
                eleMap.put(ele.getName(), children);
            }
        } else {
            HashMap<String, String> valueMap = new HashMap<String, String>();
            valueMap.put("value", ele.getText().trim());
            eleMap.put(ele.getName(), valueMap);
        }
        return eleMap;
    }

    public static String formatXml(String xml, String encoding) throws DocumentException {
        Document document = DocumentHelper.parseText((String)xml);
        OutputFormat format = OutputFormat.createPrettyPrint();
        format.setEncoding(encoding);
        StringWriter sWriter = new StringWriter();
        XMLWriter output = null;
        try {
            output = new XMLWriter((Writer)sWriter, format);
            output.write(document);
            output.close();
            return sWriter.toString();
        }
        catch (UnsupportedEncodingException e) {
            e.printStackTrace();
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return xml;
    }
}

