/*
 * Decompiled with CFR 0.152.
 */
package cn.com.yusys.yusp.yuin.base.util;

import java.text.DateFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.Locale;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DateUtil {
    private static final Logger log = LoggerFactory.getLogger(DateUtil.class);

    public static String getDateFormat(Date date, String format) {
        if (date == null) {
            return "";
        }
        SimpleDateFormat sdf = new SimpleDateFormat(format);
        return sdf.format(date);
    }

    public static String getDefaultFormat(Date date) {
        DateFormat df = DateFormat.getDateTimeInstance(2, 2, Locale.CHINA);
        return df.format(date);
    }

    public static Date getStringTime1(String dateStr) throws Exception {
        if (dateStr == null || "".equals(dateStr)) {
            return null;
        }
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd");
        Date date = null;
        try {
            date = sdf.parse(dateStr);
        }
        catch (ParseException e) {
            throw new RuntimeException("\u683c\u5f0f\u5316\u8f6c\u6362\u65e5\u671f\u5931\u8d25");
        }
        return date;
    }

    public static Date getStringTime1(String dateStr, String datepater) throws Exception {
        if (dateStr == null || "".equals(dateStr)) {
            return null;
        }
        SimpleDateFormat sdf = new SimpleDateFormat(datepater);
        Date date = null;
        try {
            date = sdf.parse(dateStr);
        }
        catch (ParseException e) {
            throw new RuntimeException("\u683c\u5f0f\u5316\u8f6c\u6362\u65e5\u671f\u5931\u8d25");
        }
        return date;
    }

    public static String getDateString() {
        StringBuffer dateStr = new StringBuffer();
        Calendar now = Calendar.getInstance();
        Integer year = now.get(1);
        dateStr.append(year);
        Integer month = now.get(2) + 1;
        if (month.toString().length() == 1) {
            dateStr.append("0");
            dateStr.append(month);
        } else {
            dateStr.append(month);
        }
        Integer day = now.get(5);
        if (day.toString().length() == 1) {
            dateStr.append("0");
            dateStr.append(day);
        } else {
            dateStr.append(day);
        }
        return dateStr.toString();
    }

    public static String getTimeString() {
        StringBuffer dateStr = new StringBuffer();
        Calendar now = Calendar.getInstance();
        Integer hour = now.get(11);
        if (hour.toString().length() == 1) {
            dateStr.append("0");
            dateStr.append(hour);
        } else {
            dateStr.append(hour);
        }
        Integer minute = now.get(12);
        if (minute.toString().length() == 1) {
            dateStr.append("0");
            dateStr.append(minute);
        } else {
            dateStr.append(minute);
        }
        return dateStr.toString();
    }

    public static String dataToString(Date DateStr) throws ParseException {
        String date = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss").format(DateStr);
        return date;
    }

    public static Date stingTODate(String dateStr) throws ParseException {
        Date date = null;
        if (dateStr != null && !dateStr.equals("")) {
            if (dateStr.matches("\\d{4}-\\d{1,2}-\\d{1,2}")) {
                dateStr = dateStr + " 00:00";
            } else if (dateStr.matches("\\d{4}-\\d{1,2}-\\d{1,2} \\d{1,2}")) {
                dateStr = dateStr + ":00";
            } else {
                return null;
            }
        }
        SimpleDateFormat format = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        date = format.parse(dateStr);
        return date;
    }

    public static Date stingTODate(String dateStr, String arg) throws ParseException {
        if (dateStr != null && !dateStr.equals("")) {
            SimpleDateFormat format = new SimpleDateFormat(arg);
            Date date = format.parse(dateStr);
            return date;
        }
        return null;
    }

    public static Date sqlToUntil(java.sql.Date sqlData) {
        Date untilDate = new Date(sqlData.getTime());
        return untilDate;
    }

    public static java.sql.Date untilToSql(Date utilData) {
        java.sql.Date sqllDate = new java.sql.Date(utilData.getTime());
        return sqllDate;
    }

    public static Date getDateByCount(String startDate, int yearCount, int monthCount, int dayCount) throws ParseException {
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(new Date(new SimpleDateFormat("yyyyMMdd").parse(startDate).getTime()));
        if (yearCount > 0) {
            calendar.add(1, yearCount);
        }
        if (monthCount != 0) {
            calendar.add(2, monthCount);
        }
        if (dayCount != 0) {
            calendar.add(5, dayCount);
        }
        return calendar.getTime();
    }

    public static Long getRemainingdays(String startDate, String endDate) throws Exception {
        try {
            long start = new SimpleDateFormat("yyyyMMdd").parse(startDate).getTime();
            long end = new SimpleDateFormat("yyyyMMdd").parse(endDate).getTime();
            long day = (end - start) / 1000L / 60L / 60L / 24L;
            return day;
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
            return 0L;
        }
    }

    public static String format(String datesrc, String srcFormat, String toFormat) {
        Date srcdate;
        SimpleDateFormat sdf = new SimpleDateFormat(srcFormat);
        try {
            srcdate = sdf.parse(datesrc);
        }
        catch (ParseException e) {
            throw new RuntimeException("\u683c\u5f0f\u5316\u8f6c\u6362\u65e5\u671f\u5931\u8d25");
        }
        sdf.applyPattern(toFormat);
        return sdf.format(srcdate);
    }

    public static Long getDateSpaceNew(String date) throws Exception {
        String newdate = DateUtil.getDateString().replace("-", "");
        return DateUtil.getRemainingdays(date, newdate);
    }
}

