/*
 * Decompiled with CFR 0.152.
 */
package cn.com.yusys.yusp.yuin.base.pcomponent;

import cn.com.yusys.yuin.base.YuinResult;
import cn.com.yusys.yusp.commons.fee.common.annotation.ide.CataLog;
import cn.com.yusys.yusp.commons.fee.common.annotation.ide.Logic;
import cn.com.yusys.yusp.commons.fee.common.enums.ActionNodeType;
import cn.com.yusys.yusp.commons.fee.common.enums.LableType;
import cn.com.yusys.yusp.yuin.base.bcomponent.B_PUB_Param;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@CataLog(nodeType=ActionNodeType.BIZ, value="\u65e5\u671f\u5904\u7406\u7c7b", async=false, lableType=LableType.MS)
public class P_PUB_Date {
    private static final Logger log = LoggerFactory.getLogger(B_PUB_Param.class);

    public static void main(String[] args) {
        try {
            System.out.println(P_PUB_Date.P_Date_ISOComp("2010-05-01T15:09:05", "2010-05-01T15:09:10"));
            System.out.println(P_PUB_Date.P_Date_AddTime("010121", "010140"));
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static YuinResult formatter(Date date) {
        String format = "yyyymmdd";
        if (date == null) {
            return YuinResult.newFailureResult("ERR_AGR", "\u4f20\u5165\u65e5\u671f\u5bf9\u8c61\u4e3a\u7a7a");
        }
        SimpleDateFormat sdf = new SimpleDateFormat(format);
        return YuinResult.newSuccessResult(new Object[]{sdf.format(date)});
    }

    @Logic(description="\u5224\u65ad\u65e5\u671f\u5b57\u7b26\u4e32")
    public static YuinResult check(String str) {
        SimpleDateFormat format = new SimpleDateFormat("yyyyMMdd");
        try {
            format.setLenient(false);
            format.parse(str);
        }
        catch (ParseException e) {
            return YuinResult.newFailureResult("ERR_AGR", "\u4f20\u5165\u65e5\u671f\u5b57\u7b26\u4e32\u975e\u6cd5");
        }
        return YuinResult.newSuccessResult(new Object[]{true});
    }

    @Logic(description="\u5224\u65ad\u65e5\u671f\u5b57\u7b26\u4e32")
    public static Date cal(String startDate, String yearCount, String monthCount, String dayCount) throws ParseException {
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(new Date(new SimpleDateFormat("yyyyMMdd").parse(startDate).getTime()));
        if (Integer.valueOf(yearCount) > 0) {
            calendar.add(1, Integer.valueOf(yearCount));
        }
        if (Integer.valueOf(monthCount) != 0) {
            calendar.add(2, Integer.valueOf(monthCount));
        }
        if (Integer.valueOf(dayCount) != 0) {
            calendar.add(5, Integer.valueOf(dayCount));
        }
        return calendar.getTime();
    }

    public static String P_Date_DiffDays(String startDate, String endDate) throws Exception {
        try {
            long start = new SimpleDateFormat("yyyyMMdd").parse(startDate).getTime();
            long end = new SimpleDateFormat("yyyyMMdd").parse(endDate).getTime();
            long day = (end - start) / 1000L / 60L / 60L / 24L;
            return String.valueOf(day);
        }
        catch (Exception exception) {
            return "";
        }
    }

    public static Long P_Date_Diff(String startDate, String endDate) throws Exception {
        try {
            long start = new SimpleDateFormat("yyyyMMdd HHmmss").parse(startDate).getTime();
            long end = new SimpleDateFormat("yyyyMMdd HHmmss").parse(endDate).getTime();
            long day = (end - start) / 1000L;
            return day;
        }
        catch (Exception e) {
            System.out.println();
            return 0L;
        }
    }

    public static Long P_Date_ISOComp(String startDate, String endDate) throws Exception {
        try {
            long start = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss").parse(startDate).getTime();
            long end = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss").parse(endDate).getTime();
            long day = (end - start) / 1000L;
            return day;
        }
        catch (Exception e) {
            e.printStackTrace();
            log.error(e.getMessage());
            return 0L;
        }
    }

    public static void P_Date_Sleep(int intSc) {
        try {
            Thread.sleep(intSc);
        }
        catch (InterruptedException e) {
            e.printStackTrace();
            log.error(e.getMessage());
        }
    }

    public static String P_Date_AddTime(String strTime1, String strTime2) {
        if (strTime1.length() != 6 || strTime2.length() != 6) {
            return "";
        }
        int intH1 = Integer.valueOf(strTime1.substring(0, 2));
        int intH2 = Integer.valueOf(strTime2.substring(0, 2));
        int intM1 = Integer.valueOf(strTime1.substring(2, 4));
        int intM2 = Integer.valueOf(strTime2.substring(2, 4));
        int intS1 = Integer.valueOf(strTime1.substring(4, 6));
        int intS2 = Integer.valueOf(strTime2.substring(4, 6));
        int addM = (intS1 + intS2) / 60;
        String strTimeR = String.format("%02d", (intS1 + intS2) % 60);
        int addH = (intM1 + intM2 + addM) / 60;
        strTimeR = String.format("%02d", (intM1 + intM2 + addM) % 60) + strTimeR;
        strTimeR = String.format("%02d", (intH1 + intH2 + addH) % 24) + strTimeR;
        return strTimeR;
    }
}

