/*
 * Decompiled with CFR 0.152.
 */
package cn.com.yusys.yuin.base.db;

import cn.com.yusys.yuin.base.db.CollectionUtil;
import cn.com.yusys.yuin.base.db.Column;
import cn.com.yusys.yuin.base.db.DbParam;
import cn.com.yusys.yuin.base.db.Requires;
import cn.com.yusys.yuin.base.db.Table;
import cn.com.yusys.yuin.base.db.TupleUtil;
import cn.com.yusys.yusp.yuin.base.util.StringUtilEx;
import java.lang.reflect.Field;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class SqlBuildUtil {
    public static final String PARAUPDATE = "_U";

    public static void buildStringFieldCondition(StringBuilder whereClause, Map<String, Object> paramMap, String fieldValue, String fieldName) {
        if (fieldValue != null) {
            SqlBuildUtil.buildStringFieldCondition(whereClause, paramMap, "AND", fieldValue, fieldName, "=", fieldName);
        }
    }

    public static void buildStringFieldCondition(StringBuilder whereClause, Map<String, Object> paramMap, String logicOperator, String fieldValue, String fieldName, String compareOperator, String parameterName) {
        Requires.notNull(whereClause, "whereClause");
        Requires.notNull(paramMap, "paramMap");
        Requires.notNullOrEmpty(logicOperator, "logicOperator");
        Requires.notNullOrEmpty(fieldName, "fieldName");
        Requires.notNullOrEmpty(compareOperator, "compareOperator");
        Requires.notNullOrEmpty(parameterName, "parameterName");
        if (!StringUtilEx.isNullOrEmpty(fieldValue)) {
            whereClause.append(String.format(" %s %s%s:%s", logicOperator, fieldName, compareOperator, parameterName));
            paramMap.put(parameterName, fieldValue);
        }
    }

    public static void buildDateFieldCondition(StringBuilder whereClause, Map<String, Object> paramMap, Date fieldValue, String fieldName) {
        if (fieldValue != null) {
            SqlBuildUtil.buildDateFieldCondition(whereClause, paramMap, "AND", fieldValue, fieldName, "=", fieldName);
        }
    }

    public static void buildDateFieldCondition(StringBuilder whereClause, Map<String, Object> paramMap, String logicOperator, Date fieldValue, String fieldName, String compareOperator, String parameterName) {
        Requires.notNull(whereClause, "whereClause");
        Requires.notNull(paramMap, "paramMap");
        Requires.notNullOrEmpty(logicOperator, "logicOperator");
        Requires.notNull(fieldValue, "fieldValue");
        Requires.notNullOrEmpty(fieldName, "fieldName");
        Requires.notNullOrEmpty(compareOperator, "compareOperator");
        Requires.notNullOrEmpty(parameterName, "parameterName");
        if (null != fieldValue) {
            whereClause.append(String.format(" %s %s%s:%s", logicOperator, fieldName, compareOperator, parameterName));
            paramMap.put(parameterName, fieldValue);
        }
    }

    public static String getEntityTableName(Object entity) {
        Requires.notNull(entity, "entity");
        return entity.getClass().getAnnotation(Table.class).Name();
    }

    public static String buildSelectFieldsClauseByDBO(Class<?> entityClass) {
        Field[] fields;
        Requires.notNull(entityClass, "entityClass");
        String sqlFields = "";
        for (Field field : fields = entityClass.getDeclaredFields()) {
            String fieldName = null;
            if (field.isAnnotationPresent(Column.class)) {
                fieldName = field.getAnnotation(Column.class).Name();
            }
            if (fieldName == null || fieldName.equals("")) {
                fieldName = field.getName();
            }
            if (!sqlFields.isEmpty()) {
                sqlFields = sqlFields + ",";
            }
            sqlFields = sqlFields + fieldName;
        }
        return sqlFields;
    }

    public static String buildSelectFieldsClauseByDBO(Class<?> entityClass, String prefix) {
        Field[] fields;
        Requires.notNull(entityClass, "entityClass");
        String sqlFields = "";
        for (Field field : fields = entityClass.getDeclaredFields()) {
            String fieldName = null;
            if (field.isAnnotationPresent(Column.class)) {
                fieldName = field.getAnnotation(Column.class).Name();
            }
            if (fieldName == null || fieldName.equals("")) {
                fieldName = field.getName();
            }
            if (!sqlFields.isEmpty()) {
                sqlFields = sqlFields + ",";
            }
            sqlFields = sqlFields + prefix + "." + fieldName;
        }
        return sqlFields;
    }

    public static <T> String buildWhereClauseAndParamMap(T entity, Map<String, Object> paramMap) throws IllegalArgumentException, IllegalAccessException {
        Requires.notNull(entity, "entity");
        Requires.notNull(paramMap, "paramMap");
        String whereClause = "WHERE 1=1";
        whereClause = whereClause + SqlBuildUtil.buildConditionAndParamMap(entity, "", paramMap);
        return whereClause;
    }

    public static <T> String buildConditionAndParamMap(T entity, String prefix, Map<String, Object> paramMap) throws IllegalArgumentException, IllegalAccessException {
        Field[] fields;
        Requires.notNull(entity, "entity");
        Requires.notNull(paramMap, "paramMap");
        StringBuilder builder = new StringBuilder();
        for (Field field : fields = entity.getClass().getDeclaredFields()) {
            String fieldName = null;
            if (field.isAnnotationPresent(Column.class)) {
                fieldName = field.getAnnotation(Column.class).Name();
            }
            if (fieldName == null || fieldName.equals("")) {
                fieldName = field.getName();
            }
            field.setAccessible(true);
            Object fieldValue = field.get(entity);
            if (fieldValue == null || fieldValue instanceof String && ((String)fieldValue).trim().equals("")) continue;
            if (StringUtilEx.isNullOrEmpty(prefix)) {
                builder.append(String.format(" AND %1$s=:%1$s", fieldName));
                paramMap.put(fieldName, fieldValue);
                continue;
            }
            builder.append(String.format(" AND %1$s.%2$s=:%1$s.%2$s", prefix, fieldName));
            paramMap.put(String.format("%s.%s", prefix, fieldName), fieldValue);
        }
        return builder.toString();
    }

    public static String createDeleteSql(DbParam dbParam) throws Exception {
        try {
            StringBuffer deleteSql = new StringBuffer();
            deleteSql.append(String.format("DELETE FROM %s WHERE 1=1 ", dbParam.getTableName()));
            if (dbParam.getWhereMap() != null) {
                Map<String, Object> filterMap = CollectionUtil.filterMapValueIsNull(dbParam.getWhereMap());
                Object[] col = filterMap.keySet().toArray();
                for (int i = 0; i < col.length; ++i) {
                    String s = String.format(" AND %s=:%s ", (String)col[i], (String)col[i]);
                    deleteSql.append(s);
                }
            }
            return deleteSql.toString();
        }
        catch (Exception e) {
            throw new Exception("\u8bbf\u95ee\u6570\u636e\u5e93\u5f02\u5e38", e);
        }
    }

    public static String createInsertSql(DbParam dbParam) throws Exception {
        try {
            if (dbParam.getValueMap() == null || dbParam.getValueMap().size() == 0) {
                return null;
            }
            Map<String, Object> filterMap = CollectionUtil.filterMapValueIsNull(dbParam.getValueMap());
            StringBuffer colBuffers = new StringBuffer();
            StringBuffer valBuffers = new StringBuffer();
            for (String key : filterMap.keySet()) {
                String valBuffer = String.format(":%s,", key.trim());
                String colBuffer = String.format("%s,", key.trim());
                valBuffers.append(valBuffer);
                colBuffers.append(colBuffer);
            }
            if (colBuffers.length() == 0 || colBuffers.length() == 0) {
                return null;
            }
            colBuffers = colBuffers.deleteCharAt(colBuffers.lastIndexOf(","));
            valBuffers = valBuffers.deleteCharAt(valBuffers.lastIndexOf(","));
            String insertSql = String.format("INSERT INTO %s (%s) VALUES (%s) ", dbParam.getTableName(), colBuffers.toString(), valBuffers.toString());
            return insertSql;
        }
        catch (Exception e) {
            throw new Exception("\u8bbf\u95ee\u6570\u636e\u5e93\u5f02\u5e38", e);
        }
    }

    public static String createUpdateSql(DbParam dbParam) throws Exception {
        try {
            int i;
            if (dbParam.getTableName() == null || dbParam.getWhereMap() == null || dbParam.getSetMap() == null) {
                return null;
            }
            Map<String, Object> filterSetMap = CollectionUtil.filterMapValueIsNull(dbParam.getSetMap());
            Map<String, Object> filterWhereValMap = CollectionUtil.filterMapValueIsNull(dbParam.getWhereMap());
            Object[] setColName = filterSetMap.keySet().toArray();
            Object[] whereColName = filterWhereValMap.keySet().toArray();
            StringBuffer updateSql = new StringBuffer();
            String update = String.format("UPDATE %s SET ", dbParam.getTableName());
            updateSql.append(update);
            for (i = 0; i < setColName.length; ++i) {
                String sqlCol = String.format("%s=:%s", setColName[i], setColName[i]);
                updateSql.append(sqlCol);
                if (i >= setColName.length - 1) continue;
                updateSql.append(", ");
            }
            updateSql.append(" WHERE 1=1 ");
            for (i = 0; i < whereColName.length; ++i) {
                updateSql.append(String.format(" AND %s=:%s%s ", whereColName[i], whereColName[i], PARAUPDATE));
            }
            return updateSql.toString();
        }
        catch (Exception e) {
            throw new Exception("\u8bbf\u95ee\u6570\u636e\u5e93\u5f02\u5e38", e);
        }
    }

    public static String createQuerySql(DbParam dbParam, String dbMode) throws Exception {
        try {
            StringBuffer querySqlBuffer = new StringBuffer();
            if (!StringUtilEx.isNullOrEmpty(dbParam.getSqlString())) {
                querySqlBuffer.append(dbParam.getSqlString());
            } else {
                int i;
                Object[] colName;
                Map<String, Object> filterMap;
                if (StringUtilEx.isNullOrEmpty(dbParam.getTableName())) {
                    throw new Exception("\u4ea4\u6613\u5904\u7406\u5f02\u5e38");
                }
                querySqlBuffer.append("SELECT ");
                if (dbParam.getColumnMap() != null && dbParam.getColumnMap().size() > 0) {
                    filterMap = CollectionUtil.filterMapValueIsNull(dbParam.getColumnMap());
                    colName = filterMap.keySet().toArray();
                    for (i = filterMap.size() - 1; i >= 0; --i) {
                        if (i == 0) {
                            querySqlBuffer.append((String)colName[i]);
                            continue;
                        }
                        querySqlBuffer.append((String)colName[i] + ", ");
                    }
                } else {
                    querySqlBuffer.append(" * ");
                }
                querySqlBuffer.append(String.format(" FROM %s WHERE 1=1 ", dbParam.getTableName()));
                if (dbParam.getWhereMap() != null && dbParam.getWhereMap().size() > 0) {
                    filterMap = CollectionUtil.filterMapValueIsNull(dbParam.getWhereMap());
                    colName = filterMap.keySet().toArray();
                    for (i = 0; i < filterMap.size(); ++i) {
                        querySqlBuffer.append(String.format(" AND %s= :%s", (String)colName[i], (String)colName[i]));
                    }
                }
            }
            String querySql = querySqlBuffer.toString();
            if (!StringUtilEx.isNullOrEmpty(dbParam.getOrderBy())) {
                querySql = SqlBuildUtil.createQuerySqlOrderBy(querySql, dbParam.getOrderBy());
            }
            if (!StringUtilEx.isNullOrEmpty(dbParam.getTopConut())) {
                return SqlBuildUtil.createQuerySqlTopCount(querySql, dbParam.getTopConut(), dbMode);
            }
            return querySql;
        }
        catch (Exception e) {
            throw new Exception("\u4ea4\u6613\u5904\u7406\u5f02\u5e38", e);
        }
    }

    public static String createQuerySqlByPage(String sql, String orderBy, int pageSize, int pageNum, String dbMode) throws Exception {
        if (StringUtilEx.isNullOrEmpty(orderBy)) {
            throw new Exception("\u4ea4\u6613\u5904\u7406\u5f02\u5e38");
        }
        if (StringUtilEx.isNullOrEmpty(dbMode)) {
            throw new Exception("\u4ea4\u6613\u5904\u7406\u5f02\u5e38");
        }
        StringBuilder builder = new StringBuilder();
        if (StringUtilEx.equalsNotCL(dbMode, "ORACLE")) {
            builder.append("SELECT * FROM ( SELECT A.* ,ROWNUM R FROM (");
            builder.append(sql);
            builder.append("  ORDER BY ");
            builder.append(orderBy);
            builder.append(" ) A  WHERE ROWNUM <=");
            builder.append(pageNum * pageSize);
            builder.append(") B WHERE R>");
            builder.append((pageNum - 1) * pageSize);
            return builder.toString();
        }
        if (StringUtilEx.equalsNotCL(dbMode, "MSSQL")) {
            builder.append("SELECT * FROM ( SELECT TOP ");
            builder.append(pageSize);
            builder.append(" * FROM ");
            builder.append("( SELECT TOP ");
            builder.append(pageNum * pageSize);
            builder.append(" * FROM ( ");
            builder.append(sql);
            builder.append(" ) A ORDER BY A.");
            builder.append(orderBy);
            builder.append(" ASC)  B ORDER BY B.");
            builder.append(orderBy);
            builder.append(" DESC ) C ORDER BY C.");
            builder.append(orderBy);
            builder.append("  ASC");
            return builder.toString();
        }
        if (StringUtilEx.equalsNotCL(dbMode, "MYSQL")) {
            builder.append("SELECT * FROM ( SELECT * FROM ( SELECT * FROM (");
            builder.append(sql);
            builder.append(" ) A ORDER BY A.");
            builder.append(orderBy);
            builder.append(" ASC LIMIT ");
            builder.append(pageNum * pageSize);
            builder.append(")  B ORDER BY ");
            builder.append(orderBy);
            builder.append(" DESC LIMIT ");
            builder.append(pageSize);
            builder.append(" ) C ORDER BY ");
            builder.append(orderBy);
            builder.append(" ASC ");
            return builder.toString();
        }
        if (StringUtilEx.equalsNotCL(dbMode, "DB2")) {
            builder.append("SELECT * FROM ( SELECT ROW_NUMBER() OVER (ORDER BY ");
            builder.append(orderBy);
            builder.append(" ) AS ROWNUMBER,A.* FROM ( ");
            builder.append(sql);
            builder.append(" ) AS A ) WHERE ROWNUMBER<=");
            builder.append(pageNum * pageSize);
            builder.append(" AND  ROWNUMBER>");
            builder.append((pageNum - 1) * pageSize);
            return builder.toString();
        }
        return sql;
    }

    public static String createQuerySqlOrderBy(String sql, String orderBy) throws Exception {
        if (StringUtilEx.isNullOrEmpty(orderBy)) {
            throw new Exception("\u4ea4\u6613\u5904\u7406\u5f02\u5e38");
        }
        sql = String.format("SELECT * FROM(%s) A ORDER BY %s", sql, orderBy);
        return sql;
    }

    public static String createQuerySqlTopCount(String sql, String topCount, String dbMode) throws Exception {
        if (StringUtilEx.isNullOrEmpty(topCount)) {
            throw new Exception("\u4ea4\u6613\u5904\u7406\u5f02\u5e38");
        }
        if (StringUtilEx.isNullOrEmpty(dbMode)) {
            throw new Exception("\u4ea4\u6613\u5904\u7406\u5f02\u5e38");
        }
        StringBuilder builder = new StringBuilder();
        if (StringUtilEx.equalsNotCL(dbMode, "ORACLE")) {
            builder.append("SELECT * FROM ");
            builder.append("( ");
            builder.append(sql);
            builder.append(" ) B WHERE ROWNUM <=");
            builder.append(topCount);
            return builder.toString();
        }
        if (StringUtilEx.equalsNotCL(dbMode, "MSSQL")) {
            builder.append("SELECT TOP");
            builder.append(topCount);
            builder.append(" * FROM ");
            builder.append("( ");
            builder.append(sql);
            builder.append(" ) B ");
            return builder.toString();
        }
        if (StringUtilEx.equalsNotCL(dbMode, "MYSQL")) {
            builder.append("SELECT * FROM ");
            builder.append("( ");
            builder.append(sql);
            builder.append(" ) B   LIMIT ");
            builder.append(topCount);
            return builder.toString();
        }
        if (StringUtilEx.equalsNotCL(dbMode, "DB2")) {
            builder.append("SELECT * FROM ");
            builder.append("( ");
            builder.append(sql);
            builder.append(" ) B WHERE FETCH  FIRST ");
            builder.append(topCount);
            builder.append(" ROWS ONLY");
            return builder.toString();
        }
        return null;
    }

    public static String getCountSql(String sql, String Dbmode) {
        String ROWCOUNT = "ROWCOUNT";
        StringBuilder builder = new StringBuilder();
        if (Dbmode.equals("DB2") | Dbmode.equals("ORACLE")) {
            builder.append("SELECT COUNT(*) ");
            builder.append(ROWCOUNT);
            builder.append(" FROM (");
            builder.append(sql);
            builder.append(")  temptable");
            return builder.toString();
        }
        builder.append("SELECT COUNT(*) ");
        builder.append("'" + ROWCOUNT + "'");
        builder.append(" FROM (");
        builder.append(sql);
        builder.append(") as temptable");
        return builder.toString();
    }

    @Deprecated
    public static TupleUtil.Tuple2<String, Map<String, Object>> createQuerySql(String tableName, String primaryColName, List<String> primaryIds, String orderby) throws Exception {
        try {
            HashMap<String, String> sqlMap = new HashMap<String, String>();
            int index = 0;
            for (String id : primaryIds) {
                sqlMap.put(primaryColName + "_" + ++index, id);
            }
            StringBuffer querySql = new StringBuffer();
            querySql.append(String.format("SELECT * FROM %s WHERE %s IN( ", tableName, primaryColName));
            index = 0;
            for (String key : sqlMap.keySet()) {
                if (++index == sqlMap.size()) {
                    querySql.append(String.format(":%s)", key));
                    continue;
                }
                querySql.append(String.format(":%s,", key));
            }
            if (orderby != null && !"".equals(orderby)) {
                querySql.append(querySql.append(String.format(" ORDER BY %s ", orderby)));
            }
            return TupleUtil.Tuple2.tuple(querySql.toString(), sqlMap);
        }
        catch (Exception e) {
            throw new Exception("\u4ea4\u6613\u5904\u7406\u5f02\u5e38");
        }
    }
}

