/*
 * Decompiled with CFR 0.152.
 */
package cn.com.yusys.yuin.base.db;

import java.io.InputStream;
import java.io.Reader;
import java.lang.reflect.Constructor;
import java.sql.Blob;
import java.sql.Clob;
import java.sql.Date;
import java.sql.Time;
import java.sql.Timestamp;

public class ObjectCovert {
    public static Object strToObject(String param, Class<?> clazz) throws Exception {
        if (param == null) {
            return null;
        }
        Object res = null;
        if (Byte.TYPE == clazz || Byte.class == clazz) {
            if (param.length() > 0) {
                res = Byte.valueOf(param);
            }
        } else if (Short.TYPE == clazz || Short.class == clazz) {
            if (param.length() > 0) {
                res = Short.valueOf(param);
            }
        } else if (Integer.TYPE == clazz || Integer.class == clazz) {
            if (param.length() > 0) {
                res = Integer.valueOf(param);
            }
        } else if (Long.TYPE == clazz || Long.class == clazz) {
            if (param.length() > 0) {
                res = Long.valueOf(param);
            }
        } else if (Float.TYPE == clazz || Float.class == clazz) {
            if (param.length() > 0) {
                res = Float.valueOf(param);
            }
        } else if (Double.TYPE == clazz || Double.class == clazz) {
            if (param.length() > 0) {
                res = Double.valueOf(param);
            }
        } else if (Character.TYPE == clazz || Character.class == clazz) {
            res = Character.valueOf(param.charAt(0));
        } else if (Boolean.TYPE == clazz || Boolean.class == clazz) {
            if (param.length() > 0) {
                res = Boolean.parseBoolean(param);
            }
        } else if (CharSequence.class.isAssignableFrom(clazz)) {
            res = param;
        } else if (java.util.Date.class.isAssignableFrom(clazz)) {
            if (param.length() > 0) {
                try {
                    long time = Long.valueOf(param);
                    Constructor<?> constructor = clazz.getConstructor(Long.TYPE);
                    res = constructor.newInstance(time);
                }
                catch (Exception e) {
                    throw new RuntimeException(e);
                }
            }
        } else {
            res = clazz.newInstance();
        }
        return res;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String objectToStr(Object param) throws Exception {
        if (param == null) {
            return null;
        }
        Class<?> clazz = param.getClass();
        String res = null;
        if (Byte.TYPE == clazz || Byte.class == clazz) {
            res = param.toString();
        } else if (Short.TYPE == clazz || Short.class == clazz) {
            res = param.toString();
        } else if (Integer.TYPE == clazz || Integer.class == clazz) {
            res = param.toString();
        } else if (Long.TYPE == clazz || Long.class == clazz) {
            res = param.toString();
        } else if (Float.TYPE == clazz || Float.class == clazz) {
            String s = param.toString();
            res = ObjectCovert.converExponentFormatStr(s);
        } else if (Double.TYPE == clazz || Double.class == clazz) {
            String s = param.toString();
            res = ObjectCovert.converExponentFormatStr(s);
        } else if (Character.TYPE == clazz || Character.class == clazz) {
            res = param.toString();
        } else if (Boolean.TYPE == clazz || Boolean.class == clazz) {
            res = param.toString();
        } else if (CharSequence.class.isAssignableFrom(clazz)) {
            res = param.toString();
        } else if (Clob.class.isAssignableFrom(clazz)) {
            Clob clob = (Clob)param;
            try (Reader reader = clob.getCharacterStream();){
                int len = (int)clob.length();
                char[] chars = new char[len];
                reader.read(chars);
                res = new String(chars);
            }
        } else {
            res = param.toString();
        }
        return res;
    }

    private static String converExponentFormatStr(String s) {
        String res = s;
        int index = s.toUpperCase().indexOf(69);
        if (index != -1) {
            int exponent = Integer.parseInt(s.substring(index + 1));
            int doitIndex = s.indexOf(46);
            String intPart = s.substring(0, doitIndex);
            String doitPart = doitIndex != -1 ? s.substring(doitIndex + 1, index) : "";
            StringBuilder sb = new StringBuilder();
            if (exponent > 0) {
                sb.append(intPart);
                int size = doitPart.length();
                if (exponent == size) {
                    sb.append(doitPart);
                } else if (exponent < size) {
                    String numPart = doitPart.substring(0, exponent);
                    sb.append(numPart);
                    sb.append(".");
                    String decPart = doitPart.substring(exponent);
                    sb.append(decPart);
                } else {
                    sb.append(doitPart);
                    for (int i = 0; i < exponent - size; ++i) {
                        sb.append("0");
                    }
                }
            } else {
                int size = intPart.length();
                if ((exponent *= -1) == size) {
                    sb.append(intPart);
                    sb.append(doitPart);
                } else if (exponent < size) {
                    int splitIndex = size - exponent;
                    sb.append(intPart.substring(0, splitIndex));
                    sb.append(".");
                    sb.append(intPart.substring(splitIndex));
                    sb.append(doitPart);
                } else {
                    sb.append("0.");
                    for (int i = 0; i < exponent - size; ++i) {
                        sb.append("0");
                    }
                    sb.append(intPart);
                    sb.append(doitPart);
                }
            }
            res = sb.toString();
        }
        return res;
    }

    public static boolean isBaseType(Object obj) {
        if (obj == null) {
            return true;
        }
        Class<?> clazz = obj.getClass();
        if (clazz.isPrimitive()) {
            return true;
        }
        if (clazz == Byte.class || clazz == Byte.TYPE) {
            return true;
        }
        if (clazz == Short.class || clazz == Short.TYPE) {
            return true;
        }
        if (clazz == Integer.class || clazz == Integer.TYPE) {
            return true;
        }
        if (clazz == Long.class || clazz == Long.TYPE) {
            return true;
        }
        if (clazz == Float.class || clazz == Float.TYPE) {
            return true;
        }
        if (clazz == Double.class || clazz == Double.TYPE) {
            return true;
        }
        if (clazz == Character.class || clazz == Character.TYPE) {
            return true;
        }
        if (CharSequence.class.isAssignableFrom(clazz)) {
            return true;
        }
        if (java.util.Date.class.isAssignableFrom(clazz)) {
            return true;
        }
        return clazz == Boolean.class;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Object convert(Object value, Class<?> expectedType) throws Exception {
        if (value == null) {
            return value;
        }
        Class<?> clazz = value.getClass();
        if (clazz == expectedType) {
            return value;
        }
        if (clazz == Date.class && expectedType == java.util.Date.class) {
            Date date = (Date)value;
            return new java.util.Date(date.getTime());
        }
        if (clazz == Timestamp.class && expectedType == java.util.Date.class) {
            Timestamp date = (Timestamp)value;
            return new java.util.Date(date.getTime());
        }
        if (clazz == Time.class && expectedType == java.util.Date.class) {
            Timestamp date = (Timestamp)value;
            return new java.util.Date(date.getTime());
        }
        if (byte[].class == expectedType) {
            if (Blob.class.isAssignableFrom(clazz)) {
                Blob blob = (Blob)value;
                int len = (int)blob.length();
                byte[] bytes = new byte[len];
                try (InputStream in = blob.getBinaryStream();){
                    in.read(bytes);
                    byte[] byArray = bytes;
                    return byArray;
                }
            }
            if (Byte[].class == clazz) {
                Byte[] buffer = (Byte[])value;
                byte[] bytes = new byte[buffer.length];
                for (int i = 0; i < buffer.length; ++i) {
                    bytes[i] = buffer[i];
                }
                return bytes;
            }
            return (byte[])value;
        }
        if (Byte[].class == expectedType) {
            if (Blob.class.isAssignableFrom(clazz)) {
                Blob blob = (Blob)value;
                int len = (int)blob.length();
                byte[] bytes = new byte[len];
                try (InputStream in = blob.getBinaryStream();){
                    in.read(bytes);
                    byte[] byArray = bytes;
                    return byArray;
                }
            }
            if (byte[].class == clazz) {
                byte[] buffer = (byte[])value;
                Byte[] bytes = new Byte[buffer.length];
                for (int i = 0; i < buffer.length; ++i) {
                    bytes[i] = buffer[i];
                }
                return bytes;
            }
            return (Byte[])value;
        }
        String s = ObjectCovert.objectToStr(value);
        Object res = ObjectCovert.strToObject(s, expectedType);
        return res;
    }
}

