/*
 * Decompiled with CFR 0.152.
 */
package cn.com.yusys.yuin.base.db;

import cn.com.yusys.yuin.base.db.Column;
import cn.com.yusys.yuin.base.db.DbParam;
import cn.com.yusys.yuin.base.db.Table;
import java.lang.annotation.IncompleteAnnotationException;
import java.lang.reflect.Field;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class DbEntityUtil {
    public static <T> Class<T> getSenderClass(T sender) {
        return sender.getClass();
    }

    public static <T> String getTableName(T sender) {
        Class<?> annElement = sender.getClass();
        Table table = annElement.getAnnotation(Table.class);
        if (table != null) {
            return "".equals(table.Name()) ? DbEntityUtil.getSenderClass(sender).getName() : table.Name();
        }
        throw new IncompleteAnnotationException(Table.class, "Name");
    }

    public static <T> String getColunmName(Field field) {
        Field annElement = field;
        Column column = annElement.getAnnotation(Column.class);
        if (column != null) {
            return "".equals(column.Name()) ? field.getName() : column.Name();
        }
        return null;
    }

    public static <T> Map<String, Object> getParaMap(T sender) {
        Field[] fields;
        HashMap<String, Object> paraMap = new HashMap<String, Object>();
        for (Field field : fields = DbEntityUtil.getSenderClass(sender).getDeclaredFields()) {
            Field annElement = field;
            Column column = annElement.getAnnotation(Column.class);
            if (column == null) continue;
            String colName = "".equals(column.Name()) ? field.getName() : column.Name();
            Object colValue = DbEntityUtil.getSenderValue(sender, field);
            if (colValue instanceof Boolean) {
                colValue = (Boolean)colValue != false ? Integer.valueOf(1) : Integer.valueOf(0);
            }
            paraMap.put(colName, colValue);
        }
        return paraMap;
    }

    public static <T> Map<String, Class<?>> getRequiredTypeMap(T sender) {
        Field[] fields;
        HashMap requiredTypeMap = new HashMap();
        for (Field field : fields = DbEntityUtil.getSenderClass(sender).getDeclaredFields()) {
            Field annElement = field;
            Column column = annElement.getAnnotation(Column.class);
            if (column == null) continue;
            String colName = "".equals(column.Name()) ? field.getName() : column.Name();
            Class<?> clz = field.getType();
            requiredTypeMap.put(colName, clz);
        }
        return requiredTypeMap;
    }

    public static <T> Object getSenderValue(T sender, Field field) {
        field.setAccessible(true);
        Object result = null;
        try {
            result = field.get(sender);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        return result;
    }

    public static <T> void setSenderValue(T sender, Field field, Object value) {
        field.setAccessible(true);
        if (value != null) {
            Class<?> type = field.getType();
            if (type == String.class) {
                if (!(value instanceof String)) {
                    value = value.toString();
                }
            } else if (type == Boolean.class || type == Boolean.TYPE) {
                if (!(value instanceof Boolean)) {
                    value = !"0".equals(value.toString());
                }
            } else if (type == Integer.class || type == Integer.TYPE) {
                if (!(value instanceof Integer)) {
                    value = Integer.parseInt(value.toString());
                }
            } else if (type == Short.class || type == Short.TYPE) {
                if (!(value instanceof Short)) {
                    value = Short.parseShort(value.toString());
                }
            } else if (type == BigDecimal.class && !(value instanceof BigDecimal)) {
                value = BigDecimal.valueOf(Double.parseDouble(value.toString()));
            }
        }
        try {
            field.set(sender, value);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public static <T> List<T> getEntityList(List<Map<String, Object>> resultList, Class<T> cls) throws InstantiationException, IllegalAccessException {
        ArrayList<T> senderList = new ArrayList<T>();
        if (resultList == null || resultList.size() == 0) {
            return senderList;
        }
        Field[] fields = cls.getDeclaredFields();
        for (Map<String, Object> result : resultList) {
            T resultSender = cls.newInstance();
            for (String columnName : result.keySet()) {
                for (Field field : fields) {
                    String annColName = DbEntityUtil.getColunmName(field);
                    if (annColName == null || !columnName.equalsIgnoreCase(annColName)) continue;
                    DbEntityUtil.setSenderValue(resultSender, field, result.get(columnName));
                }
            }
            senderList.add(resultSender);
        }
        return senderList;
    }

    public static <T> Field getPrimaryField(Class<T> cls) {
        Field[] fields;
        for (Field field : fields = cls.getDeclaredFields()) {
            Field annElement = field;
            Column column = annElement.getAnnotation(Column.class);
            if (column == null || !column.isPrimary()) continue;
            return field;
        }
        return null;
    }

    public static <T> T getSenderOnlyWithPrimary(T sender) throws Exception {
        try {
            Class<T> cls = DbEntityUtil.getSenderClass(sender);
            T primarySender = cls.newInstance();
            Field primaryField = DbEntityUtil.getPrimaryField(cls);
            if (primaryField != null) {
                DbEntityUtil.setSenderValue(primarySender, primaryField, DbEntityUtil.getSenderValue(sender, primaryField));
                return primarySender;
            }
            throw new Exception("\u672a\u627e\u5230\u4e3b\u952e\u6ce8\u89e3\u7684\u5b9e\u4f53\u7c7b");
        }
        catch (Exception e) {
            throw new Exception("\u4ea4\u6613\u5904\u7406\u5f02\u5e38", e);
        }
    }

    public static <T> DbParam getDbParam(T colSender, T valSender, DbParam.DbSqlType sqlType) {
        DbParam dbParam = new DbParam();
        dbParam.setTableName(DbEntityUtil.getTableName(colSender));
        switch (sqlType) {
            case Insert: {
                dbParam.setValueMap(DbEntityUtil.getParaMap(colSender));
                break;
            }
            case Delete: {
                dbParam.setWhereMap(DbEntityUtil.getParaMap(colSender));
                break;
            }
            case Update: {
                dbParam.setSetMap(DbEntityUtil.getParaMap(valSender));
                dbParam.setWhereMap(DbEntityUtil.getParaMap(colSender));
                break;
            }
            case Query: {
                dbParam.setWhereMap(DbEntityUtil.getParaMap(colSender));
                dbParam.setRequiredTypeMap(DbEntityUtil.getRequiredTypeMap(colSender));
            }
        }
        Field[] fields = colSender.getClass().getDeclaredFields();
        HashMap<String, Object> map = new HashMap<String, Object>();
        for (Field field : fields) {
            String annColName = DbEntityUtil.getColunmName(field);
            map.put(annColName, annColName);
        }
        dbParam.setColumnMap(map);
        return dbParam;
    }

    public static <T> T checkPropertyValue(T value, T defaultValue) {
        if (value == null) {
            return defaultValue;
        }
        return value;
    }

    public static <T> T map2Object(Map<String, Object> result, Class<T> cls) throws Exception {
        Field[] fields = cls.getDeclaredFields();
        T resultSender = cls.newInstance();
        for (String columnName : result.keySet()) {
            for (Field field : fields) {
                String annColName = DbEntityUtil.getColunmName(field);
                if (annColName == null || !columnName.equalsIgnoreCase(annColName)) continue;
                DbEntityUtil.setSenderValue(resultSender, field, result.get(columnName));
            }
        }
        return resultSender;
    }

    public static <T> List<Map<String, Object>> EntityList(List<T> resultList, Class<T> cls) {
        ArrayList<Map<String, Object>> list = new ArrayList<Map<String, Object>>();
        for (T t : resultList) {
            Field[] fields;
            HashMap<String, Object> paraMap = new HashMap<String, Object>();
            for (Field field : fields = DbEntityUtil.getSenderClass(t).getDeclaredFields()) {
                Field annElement = field;
                Column column = annElement.getAnnotation(Column.class);
                if (column == null) continue;
                String colName = "".equals(column.Name()) ? field.getName() : column.Name();
                Object colValue = DbEntityUtil.getSenderValue(t, field);
                paraMap.put(colName.toUpperCase(), colValue);
            }
            list.add(paraMap);
        }
        return list;
    }
}

