/*
 * Decompiled with CFR 0.152.
 */
package cn.com.yusys.yuin.base.db;

import cn.com.yusys.yuin.base.db.DbEntityUtil;
import java.lang.constant.Constable;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class CollectionUtil {
    public static <T> Map<Object, T> convertList2SingleMap(List<T> senderList, String fieldName) throws Exception {
        if (senderList == null) {
            return null;
        }
        HashMap<Object, T> map = new HashMap<Object, T>();
        for (T sender : senderList) {
            Field field = sender.getClass().getDeclaredField(fieldName);
            field.setAccessible(true);
            map.put(field.get(sender), sender);
        }
        return map;
    }

    public static <T> Map<Object, List<T>> convertList2GroupMap(List<T> senderList, String fieldName) throws Exception {
        if (senderList == null) {
            return null;
        }
        HashMap<Object, List<T>> senderMap = new HashMap<Object, List<T>>();
        for (T sender : senderList) {
            Field field = sender.getClass().getDeclaredField(fieldName);
            field.setAccessible(true);
            Object value = field.get(sender);
            if (!senderMap.keySet().contains(value)) {
                ArrayList<T> tempList = new ArrayList<T>();
                tempList.add(sender);
                senderMap.put(value, tempList);
                continue;
            }
            ((List)senderMap.get(value)).add(sender);
        }
        return senderMap;
    }

    public static <T> List<T> cloneEntityList(List<T> list) throws InstantiationException, IllegalAccessException {
        ArrayList resultList = new ArrayList();
        Class<T> cls = null;
        if (list.size() == 0) {
            return resultList;
        }
        for (T entity : list) {
            if (entity == null) {
                resultList.add(null);
                continue;
            }
            if (cls == null) {
                cls = DbEntityUtil.getSenderClass(entity);
            }
            Object tempEntity = cls.newInstance();
            for (Field field : cls.getDeclaredFields()) {
                DbEntityUtil.setSenderValue(tempEntity, field, DbEntityUtil.getSenderValue(entity, field));
            }
            resultList.add(tempEntity);
        }
        return resultList;
    }

    public static <T> Map<String, Object> getRenameKeyMap(Map<String, Object> senderMap, String ext) {
        HashMap<String, Object> map = new HashMap<String, Object>();
        for (String key : senderMap.keySet()) {
            map.put(key + ext, senderMap.get(key));
        }
        return map;
    }

    public static Map<String, Object> filterMapValueIsNull(Map<String, Object> map) {
        HashMap<String, Object> filterMap = new HashMap<String, Object>();
        for (String key : map.keySet()) {
            Object value = map.get(key);
            if (value == null) continue;
            filterMap.put(key, value);
        }
        return filterMap;
    }

    public static Map<String, String> getStringMap(Map<String, Class<?>> classMap) throws Exception {
        HashMap<String, String> stringMap = new HashMap<String, String>();
        if (classMap != null && classMap.size() > 0) {
            for (String key : classMap.keySet()) {
                String className = classMap.get(key).toString();
                if (className.startsWith("class ")) {
                    stringMap.put(key, className.substring(6));
                    continue;
                }
                stringMap.put(key, className);
            }
        }
        return stringMap;
    }

    public static Map<String, Class<?>> getClassMapUpperKey(Map<String, String> stringMap) throws Exception {
        HashMap classMap = new HashMap();
        if (stringMap != null && stringMap.size() > 0) {
            for (String key : stringMap.keySet()) {
                String className = stringMap.get(key);
                Class<Constable> classTemp = null;
                classTemp = className.equals(Boolean.TYPE.getName()) ? Boolean.TYPE : (className.equals(Integer.TYPE.getName()) ? Integer.TYPE : (className.equals(Double.TYPE.getName()) ? Double.TYPE : (className.equals(Float.TYPE.getName()) ? Float.TYPE : (className.equals(Byte.TYPE.getName()) ? Byte.TYPE : (className.equals(Short.TYPE.getName()) ? Short.TYPE : (className.equals(Long.TYPE.getName()) ? Long.TYPE : (className.equals(Character.TYPE.getName()) ? Character.TYPE : Class.forName(className))))))));
                classMap.put(key.toUpperCase(), classTemp);
            }
        }
        return classMap;
    }

    public static <T, RESULT> List<RESULT> select(List<T> source, ISelector<T, RESULT> selector) {
        ArrayList<RESULT> result = new ArrayList<RESULT>();
        for (T o : source) {
            result.add(selector.select(o));
        }
        return result;
    }

    public static <T> List<T> where(List<T> source, IPredicate<T> predicate) {
        ArrayList<T> result = new ArrayList<T>();
        for (T o : source) {
            if (!predicate.is(o)) continue;
            result.add(o);
        }
        return result;
    }

    public static <T> T first(Collection<T> source) {
        if (source.isEmpty()) {
            return null;
        }
        return source.iterator().next();
    }

    public static interface IPredicate<T> {
        public boolean is(T var1);
    }

    public static interface ISelector<T, RESULT> {
        public RESULT select(T var1);
    }
}

