/*
 * Decompiled with CFR 0.152.
 */
package cn.com.yusys.yuin.base.db;

import cn.com.yusys.yuin.base.db.ObjectCovert;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.LinkedHashMap;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ClassRefletUtil {
    private static Logger logger = LoggerFactory.getLogger(ClassRefletUtil.class);

    private static String getGetter(String fieldName) {
        StringBuilder sb = new StringBuilder();
        sb.append("get");
        char c = fieldName.charAt(0);
        if (c >= 'a' && c <= 'z') {
            sb.append((char)(c - 32));
        } else {
            sb.append(c);
        }
        if (fieldName.length() > 1) {
            sb.append(fieldName.substring(1));
        }
        String getter = sb.toString();
        return getter;
    }

    private static String getSetter(String fieldName) {
        StringBuilder sb = new StringBuilder();
        sb.append("set");
        char c = fieldName.charAt(0);
        if (c >= 'a' && c <= 'z') {
            sb.append((char)(c - 32));
        } else {
            sb.append(c);
        }
        if (fieldName.length() > 1) {
            sb.append(fieldName.substring(1));
        }
        String setter = sb.toString();
        return setter;
    }

    public static void setFieldValue(Class<?> clazz, Object instance, String name, Object value) throws Exception {
        boolean flag = false;
        try {
            Class[] parameterTypes = new Class[1];
            String getter = ClassRefletUtil.getGetter(name);
            Method getterMethod = clazz.getMethod(getter, new Class[0]);
            if (getterMethod != null) {
                parameterTypes[0] = getterMethod.getReturnType();
                String setter = ClassRefletUtil.getSetter(name);
                Method setterMethod = clazz.getMethod(setter, parameterTypes);
                Object arg = ObjectCovert.convert(value, parameterTypes[0]);
                setterMethod.invoke(instance, arg);
                flag = true;
            }
        }
        catch (Exception e) {
            logger.warn(e.getMessage(), (Throwable)e);
        }
        if (!flag) {
            try {
                Field field = clazz.getDeclaredField(name);
                field.setAccessible(true);
                Class<?> parameterType = field.getType();
                Object arg = ObjectCovert.convert(value, parameterType);
                field.set(instance, arg);
                flag = true;
            }
            catch (Exception e) {
                logger.warn(e.getMessage(), (Throwable)e);
            }
        }
        if (!flag) {
            throw new Exception("field[" + name + "] not exist");
        }
    }

    public static Object getFieldValue(Class<?> clazz, Object instance, String name) throws Exception {
        try {
            String getter = ClassRefletUtil.getGetter(name);
            Method getterMethod = clazz.getMethod(getter, new Class[0]);
            if (getterMethod != null) {
                Object res = getterMethod.invoke(instance, new Object[0]);
                return res;
            }
        }
        catch (Exception e) {
            logger.warn(e.getMessage(), (Throwable)e);
        }
        try {
            Field field = clazz.getDeclaredField(name);
            field.setAccessible(true);
            Object res = field.get(instance);
            return res;
        }
        catch (Exception e) {
            logger.warn(e.getMessage(), (Throwable)e);
            throw new Exception("field[" + name + "] not exist");
        }
    }

    public static Map<String, Field> getFields(Class<?> clazz) {
        LinkedHashMap<String, Field> fields = new LinkedHashMap<String, Field>();
        Class<?> c = clazz;
        do {
            for (Field field : c.getDeclaredFields()) {
                if ((field.getModifiers() & 0x88) != 0 || fields.put(field.getName(), field) == null) continue;
                throw new RuntimeException("duplicate field exception");
            }
        } while ((c = c.getSuperclass()) != null);
        return fields;
    }
}

