/*
 * Decompiled with CFR 0.152.
 */
package cn.com.yusys.yuin.base;

import cn.com.yusys.yuin.base.LogLevel;
import cn.com.yusys.yusp.yuin.base.util.ExceptionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AppLogger {
    private static Logger logger = LoggerFactory.getLogger(AppLogger.class);

    public static void info(String msg) {
        AppLogger.log(LogLevel.INFO, msg);
    }

    public static void info(Throwable throwable) {
        AppLogger.log(LogLevel.INFO, throwable);
    }

    public static void debug(String msg) {
        AppLogger.log(LogLevel.DEBUG, msg);
    }

    public static void debug(Throwable throwable) {
        AppLogger.log(LogLevel.DEBUG, throwable);
    }

    public static void trace(String msg) {
        AppLogger.log(LogLevel.TRACE, msg);
    }

    public static void trace(Throwable throwable) {
        AppLogger.log(LogLevel.TRACE, throwable);
    }

    public static void error(String msg) {
        AppLogger.log(LogLevel.ERROR, msg);
    }

    public static void error(Throwable throwable) {
        AppLogger.log(LogLevel.ERROR, throwable);
    }

    public static void warn(Object msg) {
        AppLogger.log(LogLevel.WARN, msg);
    }

    public static void log(LogLevel level, Object msg) {
        System.out.println(msg);
        String encoding = "UTF-8";
        switch (level) {
            case TRACE: {
                if (!logger.isTraceEnabled()) {
                    return;
                }
                logger.trace(AppLogger.convertMsgToBytes(msg, encoding));
                break;
            }
            case DEBUG: {
                if (!logger.isDebugEnabled()) {
                    return;
                }
                logger.debug(AppLogger.convertMsgToBytes(msg, encoding));
                break;
            }
            case INFO: {
                if (!logger.isInfoEnabled()) {
                    return;
                }
                logger.info(AppLogger.convertMsgToBytes(msg, encoding));
                break;
            }
            case WARN: {
                if (!logger.isWarnEnabled()) {
                    return;
                }
                logger.warn(AppLogger.convertMsgToBytes(msg, encoding));
                break;
            }
            case ERROR: {
                if (!logger.isErrorEnabled()) {
                    return;
                }
                logger.error(AppLogger.convertMsgToBytes(msg, encoding));
            }
        }
    }

    private static String convertMsgToBytes(Object msg, String encoding) {
        try {
            if (msg == null) {
                return "";
            }
            if (msg instanceof byte[]) {
                return new String((byte[])msg, encoding);
            }
            if (msg instanceof Throwable) {
                msg = ExceptionUtils.toDetailString((Throwable)msg);
            }
            return msg.toString();
        }
        catch (Exception e) {
            throw new Error(e.getMessage(), e);
        }
    }
}

