/*
 * Decompiled with CFR 0.152.
 */
package com.beeb.uip.file.service;

import com.beeb.uip.file.api.ProxyService;
import com.beeb.uip.file.service.AbstractFileService;
import com.beeb.uip.file.service.ProxyFeignClient;
import feign.Response;
import java.io.IOException;
import javax.annotation.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

@Service
public class ProxyServiceImpl
extends AbstractFileService
implements ProxyService {
    private static final Logger logger = LoggerFactory.getLogger(ProxyServiceImpl.class);
    @Resource
    private ProxyFeignClient client;

    public byte[] read(String url) throws IOException {
        long t0 = System.currentTimeMillis();
        Response response = this.client.read(url);
        byte[] file = this.read(response);
        logger.info("Read remote {} to local byte[], time elapsed {}ms", (Object)url, (Object)(System.currentTimeMillis() - t0));
        return file;
    }

    public String read(String url, String fileName, String localDirectory) throws IOException {
        long t0 = System.currentTimeMillis();
        Response response = this.client.read(url);
        String localPath = this.storage(response, fileName, localDirectory);
        logger.info("Read remote {} to local {}, time elapsed {}ms", new Object[]{url, localPath, System.currentTimeMillis() - t0});
        return localPath;
    }
}

