/*
 * Decompiled with CFR 0.152.
 */
package com.beeb.uip.file.service;

import cn.com.yusys.yusp.commons.exception.IMessage;
import cn.com.yusys.yusp.commons.exception.Mesaages;
import cn.com.yusys.yusp.commons.util.Asserts;
import cn.com.yusys.yusp.commons.web.rest.dto.ResultDto;
import com.beeb.uip.file.api.FileService;
import com.beeb.uip.file.domain.Criteria;
import com.beeb.uip.file.domain.Metadata;
import com.beeb.uip.file.multipart.MemoryMultipartFile;
import com.beeb.uip.file.service.AbstractFileService;
import com.beeb.uip.file.service.FileFeignClient;
import feign.Response;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Paths;
import java.util.List;
import javax.annotation.Resource;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;

@Service
public class FileServiceImpl
extends AbstractFileService
implements FileService {
    @Resource
    private FileFeignClient client;
    @Value(value="${spring.application.name}")
    private String appId;

    public Metadata get(String id) {
        Asserts.assertNonNull((String)id, (IMessage)Mesaages.ARGUMENT_REQUIRED, (Object[])new Object[]{"id"});
        ResultDto<Metadata> response = this.client.get(id);
        this.checkState(response);
        return (Metadata)response.getData();
    }

    public List<Metadata> list(Criteria criteria) {
        ResultDto<List<Metadata>> response = this.client.list(criteria);
        this.checkState(response);
        return (List)response.getData();
    }

    public byte[] read(String id) throws IOException {
        Asserts.assertNonNull((String)id, (IMessage)Mesaages.ARGUMENT_REQUIRED, (Object[])new Object[]{"id"});
        Response response = this.client.read(id);
        return this.read(response);
    }

    public String read(String id, String localDirectory) throws IOException {
        Asserts.assertNonNull((String)id, (IMessage)Mesaages.ARGUMENT_REQUIRED, (Object[])new Object[]{"id"});
        Asserts.assertNonNull((String)id, (IMessage)Mesaages.ARGUMENT_REQUIRED, (Object[])new Object[]{"localDirectory"});
        Response response = this.client.read(id);
        String fileName = this.getFileName(response, id);
        return this.storage(response, fileName, localDirectory);
    }

    public String write(String localFilePath, Integer expireDay, String bizSeq, String remark) throws IOException {
        return this.write("", localFilePath, expireDay, bizSeq, remark);
    }

    public String write(byte[] file, String fileName, Integer expireDay, String bizSeq, String remark) {
        return this.write("", file, fileName, expireDay, bizSeq, remark);
    }

    public String write(String id, String localFilePath, Integer expireDay, String bizSeq, String remark) throws IOException {
        Metadata metadata = this.resolvePath(localFilePath);
        byte[] file = Files.readAllBytes(Paths.get(localFilePath, new String[0]));
        return this.write(id, file, metadata.getName(), expireDay, bizSeq, remark);
    }

    public String write(String id, byte[] file, String fileName, Integer expireDay, String bizSeq, String remark) {
        Asserts.assertNonNull((Object)file, (IMessage)Mesaages.ARGUMENT_REQUIRED, (Object[])new Object[]{"file"});
        Asserts.assertNonNull((String)bizSeq, (IMessage)Mesaages.ARGUMENT_REQUIRED, (Object[])new Object[]{"bizSeq"});
        MemoryMultipartFile multipartFile = new MemoryMultipartFile(fileName, file);
        ResultDto<String> response = this.client.write(id, multipartFile, expireDay, bizSeq, this.appId, remark);
        this.checkState(response);
        return (String)response.getData();
    }

    public void override(String id, String localFilePath, Integer expireDay, String bizSeq, String remark) throws IOException {
        Metadata metadata = this.resolvePath(localFilePath);
        byte[] file = Files.readAllBytes(Paths.get(localFilePath, new String[0]));
        this.override(id, file, metadata.getName(), expireDay, bizSeq, remark);
    }

    public void override(String id, byte[] file, String fileName, Integer expireDay, String bizSeq, String remark) {
        Asserts.assertNonNull((Object)file, (IMessage)Mesaages.ARGUMENT_REQUIRED, (Object[])new Object[]{"file"});
        Asserts.assertNonNull((String)id, (IMessage)Mesaages.ARGUMENT_REQUIRED, (Object[])new Object[]{"id"});
        Asserts.assertNonNull((String)bizSeq, (IMessage)Mesaages.ARGUMENT_REQUIRED, (Object[])new Object[]{"bizSeq"});
        MemoryMultipartFile multipartFile = new MemoryMultipartFile(fileName, file);
        ResultDto response = this.client.override(id, multipartFile, expireDay, bizSeq, remark);
        this.checkState(response);
    }

    public void delete(String id) {
        ResultDto response = this.client.delete(id);
        this.checkState(response);
    }

    public byte[] readTemp(String id) throws IOException {
        Asserts.assertNonNull((String)id, (IMessage)Mesaages.ARGUMENT_REQUIRED, (Object[])new Object[]{"id"});
        Response response = this.client.readTemp(id);
        return this.read(response);
    }

    public String readTemp(String id, String localDirectory) throws IOException {
        Asserts.assertNonNull((String)id, (IMessage)Mesaages.ARGUMENT_REQUIRED, (Object[])new Object[]{"id"});
        Asserts.assertNonNull((String)id, (IMessage)Mesaages.ARGUMENT_REQUIRED, (Object[])new Object[]{"localDirectory"});
        Response response = this.client.readTemp(id);
        String fileName = this.getFileName(response, id);
        return this.storage(response, fileName, localDirectory);
    }

    public String writeTemp(String localFilePath, Integer expireDay, String bizSeq, String remark) throws IOException {
        return this.writeTemp("", localFilePath, expireDay, bizSeq, remark);
    }

    public String writeTemp(byte[] file, String fileName, Integer expireDay, String bizSeq, String remark) {
        return this.writeTemp("", file, fileName, expireDay, bizSeq, remark);
    }

    public String writeTemp(String id, String localFilePath, Integer expireDay, String bizSeq, String remark) throws IOException {
        Metadata metadata = this.resolvePath(localFilePath);
        byte[] file = Files.readAllBytes(Paths.get(localFilePath, new String[0]));
        return this.writeTemp(id, file, metadata.getName(), expireDay, bizSeq, remark);
    }

    public String writeTemp(String id, byte[] file, String fileName, Integer expireDay, String bizSeq, String remark) {
        Asserts.assertNonNull((Object)file, (IMessage)Mesaages.ARGUMENT_REQUIRED, (Object[])new Object[]{"file"});
        Asserts.assertNonNull((String)bizSeq, (IMessage)Mesaages.ARGUMENT_REQUIRED, (Object[])new Object[]{"bizSeq"});
        Asserts.assertNonNull((Object)expireDay, (IMessage)Mesaages.ARGUMENT_REQUIRED, (Object[])new Object[]{"expireDay"});
        Asserts.assertTrue((expireDay > 0 ? 1 : 0) != 0, (IMessage)Mesaages.ARGUMENT_OUT_OF_BOUNDS, (Object[])new Object[]{"expireDay", expireDay, "\u5927\u4e8e0"});
        MemoryMultipartFile multipartFile = new MemoryMultipartFile(fileName, file);
        ResultDto<String> response = this.client.writeTemp(id, multipartFile, expireDay, bizSeq, this.appId, remark);
        this.checkState(response);
        return (String)response.getData();
    }

    public void overrideTemp(String id, String localFilePath, Integer expireDay, String bizSeq, String remark) throws IOException {
        Metadata metadata = this.resolvePath(localFilePath);
        byte[] file = Files.readAllBytes(Paths.get(localFilePath, new String[0]));
        this.overrideTemp(id, file, metadata.getName(), expireDay, bizSeq, remark);
    }

    public void overrideTemp(String id, byte[] file, String fileName, Integer expireDay, String bizSeq, String remark) {
        Asserts.assertNonNull((Object)file, (IMessage)Mesaages.ARGUMENT_REQUIRED, (Object[])new Object[]{"file"});
        Asserts.assertNonNull((String)id, (IMessage)Mesaages.ARGUMENT_REQUIRED, (Object[])new Object[]{"id"});
        Asserts.assertNonNull((String)bizSeq, (IMessage)Mesaages.ARGUMENT_REQUIRED, (Object[])new Object[]{"bizSeq"});
        Asserts.assertNonNull((Object)expireDay, (IMessage)Mesaages.ARGUMENT_REQUIRED, (Object[])new Object[]{"expireDay"});
        Asserts.assertTrue((expireDay > 0 ? 1 : 0) != 0, (IMessage)Mesaages.ARGUMENT_OUT_OF_BOUNDS, (Object[])new Object[]{"expireDay", expireDay, "\u5927\u4e8e0"});
        MemoryMultipartFile multipartFile = new MemoryMultipartFile(fileName, file);
        ResultDto response = this.client.overrideTemp(id, multipartFile, expireDay, bizSeq, remark);
        this.checkState(response);
    }

    public void deleteTemp(String id) {
        ResultDto response = this.client.deleteTemp(id);
        this.checkState(response);
    }
}

