/*
 * Decompiled with CFR 0.152.
 */
package com.beeb.uip.file.service;

import cn.com.yusys.yusp.commons.web.rest.dto.ResultDto;
import com.beeb.uip.file.domain.Criteria;
import com.beeb.uip.file.domain.Metadata;
import com.beeb.uip.file.service.FileFeignClient;
import feign.Response;
import feign.hystrix.FallbackFactory;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;
import org.springframework.web.multipart.MultipartFile;

@Component
public class FileFeignClientFallback
implements FallbackFactory<FileFeignClient> {
    private static final Logger logger = LoggerFactory.getLogger(FileFeignClientFallback.class);

    public FileFeignClient create(final Throwable throwable) {
        return new FileFeignClient(){

            @Override
            public ResultDto<Metadata> get(String id) {
                return this.error("get");
            }

            @Override
            public ResultDto<List<Metadata>> list(Criteria criteria) {
                return this.error("list");
            }

            @Override
            public Response read(String id) {
                this.error("read");
                return null;
            }

            @Override
            public ResultDto<String> write(String id, MultipartFile file, Integer expireDay, String bizSeq, String appId, String remark) {
                return this.error("write");
            }

            @Override
            public ResultDto override(String id, MultipartFile file, Integer expireDay, String bizSeq, String remark) {
                return this.error("override");
            }

            @Override
            public ResultDto delete(String id) {
                return this.error("delete");
            }

            @Override
            public Response readTemp(String id) {
                this.error("readTemp");
                return null;
            }

            @Override
            public ResultDto<String> writeTemp(String id, MultipartFile file, Integer expireDay, String bizSeq, String appId, String remark) {
                return this.error("writeTemp");
            }

            @Override
            public ResultDto overrideTemp(String id, MultipartFile file, Integer expireDay, String bizSeq, String remark) {
                return this.error("overrideTemp");
            }

            @Override
            public ResultDto deleteTemp(String id) {
                return this.error("deleteTemp");
            }

            private ResultDto error(String method) {
                logger.error("Failed to call {}.", (Object)method, (Object)throwable);
                String msg = throwable == null ? "" : throwable.getClass().getName() + ":" + throwable.getMessage();
                return ResultDto.createFailure((int)999999, (String)msg);
            }
        };
    }
}

