/*
 * Decompiled with CFR 0.152.
 */
package com.beeb.uip.file.service;

import cn.com.yusys.yusp.commons.exception.IMessage;
import cn.com.yusys.yusp.commons.exception.Mesaages;
import cn.com.yusys.yusp.commons.util.Asserts;
import cn.com.yusys.yusp.commons.web.rest.dto.ResultDto;
import com.beeb.uip.file.api.FTPService;
import com.beeb.uip.file.domain.Metadata;
import com.beeb.uip.file.domain.ftp.Server;
import com.beeb.uip.file.multipart.MemoryMultipartFile;
import com.beeb.uip.file.service.AbstractFileService;
import com.beeb.uip.file.service.FTPFeignClient;
import feign.Response;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Paths;
import javax.annotation.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;

@Service
public class FTPServiceImpl
extends AbstractFileService
implements FTPService {
    private static final Logger logger = LoggerFactory.getLogger(FTPServiceImpl.class);
    @Resource
    private FTPFeignClient client;
    @Value(value="${spring.application.name}")
    private String appId;

    public String read(String remoteFilePath, String localDirectory) throws IOException {
        long t0 = System.currentTimeMillis();
        Metadata metadata = this.resolvePath(remoteFilePath);
        Response response = this.client.read(metadata.getName(), metadata.getDirectory());
        String localPath = this.storage(response, metadata.getName(), localDirectory);
        logger.info("Read remote {} to local {}, time elapsed {}ms", new Object[]{remoteFilePath, localPath, System.currentTimeMillis() - t0});
        return localPath;
    }

    public byte[] read(String remoteFilePath) throws IOException {
        long t0 = System.currentTimeMillis();
        Metadata metadata = this.resolvePath(remoteFilePath);
        Response response = this.client.read(metadata.getName(), metadata.getDirectory());
        byte[] file = this.read(response);
        logger.info("Read remote {}, time elapsed {}ms", (Object)remoteFilePath, (Object)(System.currentTimeMillis() - t0));
        return file;
    }

    public String write(String localFilePath, String remoteDirectory) throws IOException {
        long t0 = System.currentTimeMillis();
        Metadata metadata = this.resolvePath(localFilePath);
        byte[] file = Files.readAllBytes(Paths.get(localFilePath, new String[0]));
        logger.info("Write local {} to byte[], time elapsed {}ms", (Object)localFilePath, (Object)(System.currentTimeMillis() - t0));
        return this.write(file, metadata.getName(), remoteDirectory);
    }

    public String write(byte[] file, String fileName, String remoteDirectory) throws IOException {
        long t0 = System.currentTimeMillis();
        MemoryMultipartFile multipartFile = new MemoryMultipartFile(fileName, file);
        ResultDto<String> response = this.client.write(multipartFile, this.appId, remoteDirectory);
        this.checkState(response);
        String remotePath = (String)response.getData();
        logger.info("Write local byte[] to remote {}, time elapsed {}ms", (Object)remotePath, (Object)(System.currentTimeMillis() - t0));
        return remotePath;
    }

    public String read(Server server, String remoteFilePath, String localDirectory) throws IOException {
        long t0 = System.currentTimeMillis();
        this.verify(server);
        Metadata metadata = this.resolvePath(remoteFilePath);
        Response response = this.client.read(server.getProtocol(), server.getHostname(), server.getPort(), server.getUsername(), server.getPassword(), server.getCharset(), server.getTimeout(), metadata.getName(), metadata.getDirectory());
        String localPath = this.storage(response, metadata.getName(), localDirectory);
        logger.info("Read remote {} to local {}, time elapsed {}ms", new Object[]{remoteFilePath, localPath, System.currentTimeMillis() - t0});
        return localPath;
    }

    public byte[] read(Server server, String remoteFilePath) throws IOException {
        long t0 = System.currentTimeMillis();
        Metadata metadata = this.resolvePath(remoteFilePath);
        Response response = this.client.read(server.getProtocol(), server.getHostname(), server.getPort(), server.getUsername(), server.getPassword(), server.getCharset(), server.getTimeout(), metadata.getName(), metadata.getDirectory());
        byte[] file = this.read(response);
        logger.info("Read remote {} to local byte[], time elapsed {}ms", (Object)remoteFilePath, (Object)(System.currentTimeMillis() - t0));
        return file;
    }

    public String write(Server server, String localFilePath, String remoteDirectory) throws IOException {
        long t0 = System.currentTimeMillis();
        Metadata metadata = this.resolvePath(localFilePath);
        byte[] file = Files.readAllBytes(Paths.get(localFilePath, new String[0]));
        String remotePath = this.write(server, file, metadata.getName(), remoteDirectory);
        logger.info("Write local {} to byte[], time elapsed {}ms", (Object)localFilePath, (Object)(System.currentTimeMillis() - t0));
        return remotePath;
    }

    public String write(Server server, byte[] file, String fileName, String remoteDirectory) throws IOException {
        long t0 = System.currentTimeMillis();
        MemoryMultipartFile multipartFile = new MemoryMultipartFile(fileName, file);
        ResultDto<String> response = this.client.write(server.getProtocol(), server.getHostname(), server.getPort(), server.getUsername(), server.getPassword(), server.getCharset(), server.getTimeout(), multipartFile, remoteDirectory);
        this.checkState(response);
        String remotePath = (String)response.getData();
        logger.info("Write local byte[] to remote {}, time elapsed {}ms", (Object)remotePath, (Object)(System.currentTimeMillis() - t0));
        return remotePath;
    }

    private void verify(Server server) {
        Asserts.assertNonNull((Object)server, (IMessage)Mesaages.ARGUMENT_REQUIRED, (Object[])new Object[]{"server"});
        Asserts.assertNonNull((String)server.getHostname(), (IMessage)Mesaages.ARGUMENT_REQUIRED, (Object[])new Object[]{"hostname"});
        Asserts.assertNonNull((Object)server.getPort(), (IMessage)Mesaages.ARGUMENT_REQUIRED, (Object[])new Object[]{"port "});
        Asserts.assertNonNull((String)server.getUsername(), (IMessage)Mesaages.ARGUMENT_REQUIRED, (Object[])new Object[]{"username"});
        Asserts.assertNonNull((String)server.getPassword(), (IMessage)Mesaages.ARGUMENT_REQUIRED, (Object[])new Object[]{"password"});
    }
}

