/*
 * Decompiled with CFR 0.152.
 */
package com.beeb.uip.file.service;

import cn.com.yusys.yusp.commons.exception.YuspException;
import cn.com.yusys.yusp.commons.util.Asserts;
import cn.com.yusys.yusp.commons.web.rest.dto.ResultDto;
import com.beeb.uip.file.domain.Metadata;
import com.fasterxml.jackson.databind.ObjectMapper;
import feign.Response;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.http.HttpStatus;
import org.springframework.util.StreamUtils;

public abstract class AbstractFileService {
    private static final Logger logger = LoggerFactory.getLogger(AbstractFileService.class);
    public static final String PATH_SEPARATOR = "/";
    private ObjectMapper mapper = new ObjectMapper();

    protected String getFileName(Response response, String id) throws IOException {
        String fileName;
        this.checkState(response);
        try {
            Map headers = response.headers();
            List header = (List)headers.get("file-name");
            fileName = (String)header.get(0);
        }
        catch (Exception e) {
            logger.error("Failed to get download file name for {}", (Object)id);
            fileName = id;
        }
        return fileName;
    }

    protected byte[] read(Response response) throws IOException {
        this.checkState(response);
        Response.Body payload = response.body();
        Asserts.assertNonNull((Object)payload, (String)"Failed to get response body", (Object[])new Object[0]);
        return this.read(payload);
    }

    protected byte[] read(Response.Body body) throws IOException {
        byte[] file;
        try (InputStream in = body.asInputStream();
             ByteArrayOutputStream out = new ByteArrayOutputStream();){
            StreamUtils.copy((InputStream)in, (OutputStream)out);
            file = out.toByteArray();
        }
        return file;
    }

    protected String storage(Response response, String fileName, String directory) throws IOException {
        this.checkState(response);
        Response.Body payload = response.body();
        Asserts.assertNonNull((Object)payload, (String)"Failed to download.", (Object[])new Object[0]);
        this.makeDir(directory);
        StringBuffer pathBuffer = new StringBuffer();
        pathBuffer.append(directory);
        pathBuffer.append(PATH_SEPARATOR);
        pathBuffer.append(fileName);
        String path = pathBuffer.toString();
        try (InputStream in = payload.asInputStream();
             FileOutputStream out = new FileOutputStream(path);){
            StreamUtils.copy((InputStream)in, (OutputStream)out);
        }
        return path;
    }

    protected void makeDir(String directory) {
        File folder = new File(directory);
        if (!folder.exists()) {
            folder.mkdirs();
        }
    }

    protected void checkState(Response response) throws IOException {
        Asserts.assertNonNull((Object)response, (String)"Failed to get response", (Object[])new Object[0]);
        if (response.status() != HttpStatus.OK.value()) {
            String message = new String(this.read(response.body()));
            Asserts.assertNonNull((Object)response, (String)"Failed to get error message", (Object[])new Object[0]);
            ResultDto resultDto = (ResultDto)this.mapper.readValue(message, ResultDto.class);
            throw new YuspException(String.valueOf(resultDto.getCode()), resultDto.getMessage());
        }
    }

    protected void checkState(ResultDto<?> result) {
        Asserts.assertTrue((result.getCode() == 0 ? 1 : 0) != 0, (String)String.valueOf(result.getCode()), (String)result.getMessage(), (Object[])new Object[0]);
    }

    protected Metadata resolvePath(String path) {
        int index = path.lastIndexOf(PATH_SEPARATOR);
        Asserts.assertTrue((index > 0 && index < path.length() - 1 ? 1 : 0) != 0, (String)"Path invalid, must be separate by {}", (Object[])new String[]{PATH_SEPARATOR});
        String name = path.substring(index + 1);
        String directory = path.substring(0, index);
        return new Metadata(name, directory);
    }
}

