/*
 * Decompiled with CFR 0.152.
 */
package com.beeb.uip.file.service;

import cn.com.yusys.yusp.commons.web.rest.dto.ResultDto;
import com.beeb.uip.file.domain.Criteria;
import com.beeb.uip.file.domain.Metadata;
import com.beeb.uip.file.service.FileFeignClientFallback;
import feign.Contract;
import feign.Headers;
import feign.Param;
import feign.RequestLine;
import feign.Response;
import feign.codec.Encoder;
import feign.form.spring.SpringFormEncoder;
import java.util.List;
import org.springframework.beans.factory.ObjectFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.autoconfigure.http.HttpMessageConverters;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.cloud.openfeign.support.SpringEncoder;
import org.springframework.context.annotation.Bean;
import org.springframework.web.multipart.MultipartFile;

@FeignClient(name="sp-file", path="/api/file", fallbackFactory=FileFeignClientFallback.class, configuration={MultipartSupportConfig.class})
interface FileFeignClient {
    @RequestLine(value="GET /{id}")
    public ResultDto<Metadata> get(@Param(value="id") String var1);

    @RequestLine(value="GET")
    public ResultDto<List<Metadata>> list(Criteria var1);

    @RequestLine(value="GET /read/{id}")
    public Response read(@Param(value="id") String var1);

    @RequestLine(value="POST /write?id={id}&expireDay={expireDay}&bizSeq={bizSeq}&appId={appId}&remark={remark}")
    @Headers(value={"Content-Type: multipart/form-data"})
    public ResultDto<String> write(@Param(value="id") String var1, @Param(value="file") MultipartFile var2, @Param(value="expireDay") Integer var3, @Param(value="bizSeq") String var4, @Param(value="appId") String var5, @Param(value="remark") String var6);

    @RequestLine(value="POST /override?id={id}&expireDay={expireDay}&bizSeq={bizSeq}&remark={remark}")
    @Headers(value={"Content-Type: multipart/form-data"})
    public ResultDto override(@Param(value="id") String var1, @Param(value="file") MultipartFile var2, @Param(value="expireDay") Integer var3, @Param(value="bizSeq") String var4, @Param(value="remark") String var5);

    @RequestLine(value="POST /delete/{id}")
    public ResultDto delete(@Param(value="id") String var1);

    @RequestLine(value="GET /temp/read/{id}")
    public Response readTemp(@Param(value="id") String var1);

    @RequestLine(value="POST /temp/write?id={id}&expireDay={expireDay}&bizSeq={bizSeq}&appId={appId}&remark={remark}")
    @Headers(value={"Content-Type: multipart/form-data"})
    public ResultDto<String> writeTemp(@Param(value="id") String var1, @Param(value="file") MultipartFile var2, @Param(value="expireDay") Integer var3, @Param(value="bizSeq") String var4, @Param(value="appId") String var5, @Param(value="remark") String var6);

    @RequestLine(value="POST /temp/override?id={id}&expireDay={expireDay}&bizSeq={bizSeq}&remark={remark}")
    @Headers(value={"Content-Type: multipart/form-data"})
    public ResultDto overrideTemp(@Param(value="id") String var1, @Param(value="file") MultipartFile var2, @Param(value="expireDay") Integer var3, @Param(value="bizSeq") String var4, @Param(value="remark") String var5);

    @RequestLine(value="POST /temp/delete/{id}")
    public ResultDto deleteTemp(@Param(value="id") String var1);

    public static class MultipartSupportConfig {
        @Autowired
        private ObjectFactory<HttpMessageConverters> messageConverters;

        @Bean
        public Contract feignContract() {
            return new Contract.Default();
        }

        @Bean
        public Encoder feignEncoder() {
            return new SpringFormEncoder((Encoder)new SpringEncoder(this.messageConverters));
        }
    }
}

