/*
 * Decompiled with CFR 0.152.
 */
package com.beeb.uip.file.service;

import cn.com.yusys.yusp.commons.exception.IMessage;
import cn.com.yusys.yusp.commons.exception.Mesaages;
import cn.com.yusys.yusp.commons.util.Asserts;
import cn.com.yusys.yusp.commons.web.rest.dto.ResultDto;
import com.beeb.uip.file.api.FTPService;
import com.beeb.uip.file.constant.Status;
import com.beeb.uip.file.domain.Metadata;
import com.beeb.uip.file.domain.ftp.Server;
import com.beeb.uip.file.service.AbstractFeignClient;
import com.beeb.uip.file.service.FTPFeignClient;
import feign.Response;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Paths;
import javax.annotation.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;

@Service
public class FTPServiceImpl
extends AbstractFeignClient
implements FTPService {
    private static final Logger logger = LoggerFactory.getLogger(FTPServiceImpl.class);
    @Resource
    private FTPFeignClient client;
    @Value(value="${spring.application.name}")
    private String appId;

    public String read(String remoteFilePath, String localDirectory) throws IOException {
        long t0 = System.currentTimeMillis();
        Metadata metadata = this.resolvePath(remoteFilePath);
        Response response = this.client.read(metadata.getName(), metadata.getDirectory());
        Asserts.assertNonNull((Object)response, (IMessage)Status.DOWNLOAD_ERROR, (Object[])new Object[]{metadata.getName(), localDirectory});
        String localPath = this.storage(response, metadata.getName(), localDirectory);
        logger.info("Storage {} to {}, time elapsed {}ms", new Object[]{metadata.getName(), localDirectory, System.currentTimeMillis() - t0});
        return localPath;
    }

    public String write(String localFilePath, String remoteDirectory) throws IOException {
        Metadata metadata = this.resolvePath(localFilePath);
        byte[] file = Files.readAllBytes(Paths.get(localFilePath, new String[0]));
        ResultDto<String> response = this.client.write(file, metadata.getName(), this.appId, remoteDirectory);
        this.checkStatus(response);
        String remotePath = (String)response.getData();
        return remotePath;
    }

    public String read(Server server, String remoteFilePath, String localDirectory) throws IOException {
        long t0 = System.currentTimeMillis();
        this.verify(server);
        Metadata metadata = this.resolvePath(remoteFilePath);
        Response response = this.client.read(server.getHostname(), server.getPort(), server.getUsername(), server.getPassword(), server.getCharset(), metadata.getName(), metadata.getDirectory());
        Asserts.assertNonNull((Object)response, (IMessage)Status.DOWNLOAD_ERROR, (Object[])new Object[]{metadata.getName(), localDirectory});
        String localPath = this.storage(response, metadata.getName(), localDirectory);
        logger.info("Storage {} to {}, time elapsed {}ms", new Object[]{metadata.getName(), localDirectory, System.currentTimeMillis() - t0});
        return localPath;
    }

    public String write(Server server, String localFilePath, String remoteDirectory) throws IOException {
        this.verify(server);
        Metadata metadata = this.resolvePath(localFilePath);
        byte[] file = Files.readAllBytes(Paths.get(localFilePath, new String[0]));
        ResultDto<String> response = this.client.write(server.getHostname(), server.getPort(), server.getUsername(), server.getPassword(), server.getCharset(), file, metadata.getName(), remoteDirectory);
        this.checkStatus(response);
        String remotePath = (String)response.getData();
        return remotePath;
    }

    private void verify(Server server) {
        Asserts.assertNonNull((Object)server, (IMessage)Mesaages.ARGUMENT_REQUIRED, (Object[])new Object[]{"server"});
        Asserts.assertNonNull((String)server.getHostname(), (IMessage)Mesaages.ARGUMENT_REQUIRED, (Object[])new Object[]{"hostname"});
        Asserts.assertNonNull((Object)server.getPort(), (IMessage)Mesaages.ARGUMENT_REQUIRED, (Object[])new Object[]{"port "});
        Asserts.assertNonNull((String)server.getUsername(), (IMessage)Mesaages.ARGUMENT_REQUIRED, (Object[])new Object[]{"username"});
        Asserts.assertNonNull((String)server.getPassword(), (IMessage)Mesaages.ARGUMENT_REQUIRED, (Object[])new Object[]{"password"});
    }
}

