/*
 * Decompiled with CFR 0.152.
 */
package com.beeb.uip.file.service;

import cn.com.yusys.yusp.commons.web.rest.dto.ResultDto;
import com.beeb.uip.file.service.FTPFeignClient;
import feign.Response;
import feign.hystrix.FallbackFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

@Component
public class FTPFeignClientFallback
implements FallbackFactory<FTPFeignClient> {
    private static final Logger logger = LoggerFactory.getLogger(FTPFeignClientFallback.class);

    public FTPFeignClient create(final Throwable throwable) {
        return new FTPFeignClient(){

            @Override
            public Response read(String fileName, String remoteDirectory) {
                this.error("read");
                return null;
            }

            @Override
            public ResultDto<String> write(byte[] file, String fileName, String appId, String remoteDirectory) {
                return this.error("write");
            }

            @Override
            public Response read(String hostname, int port, String username, String password, String charset, String fileName, String remoteDirectory) {
                this.error("read");
                return null;
            }

            @Override
            public ResultDto<String> write(String hostname, int port, String username, String password, String charset, byte[] file, String fileName, String remoteDirectory) {
                return this.error("write");
            }

            private ResultDto error(String method) {
                logger.error("Failed to call {}.", (Object)method, (Object)throwable);
                String msg = throwable == null ? "" : throwable.getClass().getName() + ":" + throwable.getMessage();
                return ResultDto.createFailure((int)999999, (String)msg);
            }
        };
    }
}

