/*
 * Decompiled with CFR 0.152.
 */
package com.beeb.uip.file.service;

import cn.com.yusys.yusp.commons.util.Asserts;
import cn.com.yusys.yusp.commons.web.rest.dto.ResultDto;
import com.beeb.uip.file.domain.Metadata;
import feign.Response;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.http.HttpStatus;

public abstract class AbstractFeignClient {
    private static final Logger logger = LoggerFactory.getLogger(AbstractFeignClient.class);
    public static final String PATH_SEPARATOR = "/";

    protected String getFileName(Response response, String id) {
        String fileName;
        this.checkStatus(response);
        try {
            Map headers = response.headers();
            List header = (List)headers.get("file-name");
            fileName = (String)header.get(0);
        }
        catch (Exception e) {
            logger.error("Failed to get download file name for {}", (Object)id);
            fileName = id;
        }
        return fileName;
    }

    protected byte[] read(Response response) throws IOException {
        this.checkStatus(response);
        Response.Body payload = response.body();
        Asserts.assertNonNull((Object)payload, (String)"Failed to download.", (Object[])new Object[0]);
        byte[] file = null;
        try (InputStream input = payload.asInputStream();
             ByteArrayOutputStream output = new ByteArrayOutputStream();){
            int index;
            byte[] buffer = new byte[1024];
            while ((index = input.read(buffer)) != -1) {
                output.write(buffer, 0, index);
                output.flush();
            }
            file = output.toByteArray();
        }
        return file;
    }

    protected String storage(Response response, String fileName, String directory) throws IOException {
        this.checkStatus(response);
        Response.Body payload = response.body();
        Asserts.assertNonNull((Object)payload, (String)"Failed to download.", (Object[])new Object[0]);
        this.makeDir(directory);
        StringBuffer pathBuffer = new StringBuffer();
        pathBuffer.append(directory);
        pathBuffer.append(PATH_SEPARATOR);
        pathBuffer.append(fileName);
        String path = pathBuffer.toString();
        try (InputStream input = payload.asInputStream();
             FileOutputStream output = new FileOutputStream(path);){
            int index;
            byte[] buffer = new byte[1024];
            while ((index = input.read(buffer)) != -1) {
                output.write(buffer, 0, index);
                output.flush();
            }
        }
        return path;
    }

    protected void makeDir(String directory) {
        File folder = new File(directory);
        if (!folder.exists()) {
            folder.mkdirs();
        }
    }

    protected void checkStatus(Response response) {
        Asserts.assertNonNull((Object)response, (String)"Failed to call file service", (Object[])new Object[0]);
        Asserts.assertEquals((Object)response.status(), (Object)HttpStatus.OK.value(), (String)"Failed to call file service : {} - {}.", (Object[])new Object[]{response.status(), response.reason()});
    }

    protected void checkStatus(ResultDto<?> result) {
        Asserts.assertTrue((result.getCode() == 0 ? 1 : 0) != 0, (String)"Failed to call file service : {} - {}", (Object[])new Object[]{result.getCode(), result.getMessage()});
    }

    protected Metadata resolvePath(String path) {
        int index = path.lastIndexOf(PATH_SEPARATOR);
        Asserts.assertTrue((index > 0 && index < path.length() - 1 ? 1 : 0) != 0, (String)"Path invalid, must be separate by {}", (Object[])new String[]{PATH_SEPARATOR});
        String name = path.substring(index + 1);
        String directory = path.substring(0, index);
        return new Metadata(name, directory);
    }
}

