/*
 * Decompiled with CFR 0.152.
 */
package com.beeb.uip.file.multipart;

import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import org.springframework.web.multipart.MultipartFile;

public class MemoryMultipartFile
implements MultipartFile {
    private final String name;
    private final String contentType;
    private final String originalFileName;
    private final byte[] payload;

    public MemoryMultipartFile(String originalFileName, byte[] payload) {
        this.name = "file";
        this.contentType = "application/octet-stream";
        this.originalFileName = originalFileName;
        this.payload = payload;
    }

    public MemoryMultipartFile(String name, String contentType, String originalFileName, byte[] payload) {
        if (payload == null) {
            throw new IllegalArgumentException("Payload cannot be null.");
        }
        this.name = name;
        this.contentType = contentType;
        this.originalFileName = originalFileName;
        this.payload = payload;
    }

    public String getName() {
        return this.name;
    }

    public String getOriginalFilename() {
        return this.originalFileName;
    }

    public String getContentType() {
        return this.contentType;
    }

    public boolean isEmpty() {
        return this.payload.length == 0;
    }

    public long getSize() {
        return this.payload.length;
    }

    public byte[] getBytes() throws IOException {
        return this.payload;
    }

    public InputStream getInputStream() throws IOException {
        return new ByteArrayInputStream(this.payload);
    }

    public void transferTo(File dest) throws IOException, IllegalStateException {
        new FileOutputStream(dest).write(this.payload);
    }
}

