/*
 * Decompiled with CFR 0.152.
 */
package cn.com.yusys.yusp.util.redis.redislock;

import io.lettuce.core.RedisFuture;
import io.lettuce.core.ScriptOutputType;
import io.lettuce.core.SetArgs;
import io.lettuce.core.api.async.RedisAsyncCommands;
import io.lettuce.core.api.async.RedisScriptingAsyncCommands;
import io.lettuce.core.cluster.api.async.RedisAdvancedClusterAsyncCommands;
import java.util.UUID;
import java.util.concurrent.ExecutionException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.dao.DataAccessException;
import org.springframework.data.redis.connection.RedisConnection;
import org.springframework.data.redis.core.StringRedisTemplate;
import org.springframework.data.redis.serializer.RedisSerializer;
import org.springframework.stereotype.Component;

@Component
public class RedisDistributeLock
implements InitializingBean {
    private static final Logger logger = LoggerFactory.getLogger(RedisDistributeLock.class);
    private ThreadLocal<String> lockValue = new ThreadLocal();
    private static final String LOCK_SUCCESS = "OK";
    private static final String REDIS_LIB_MISMATCH = "Failed to convert nativeConnection. Is your SpringBoot version > 2.0 ? Only lib:lettuce is supported.";
    private static final String UNLOCK_LUA = "if redis.call('get', KEYS[1]) == ARGV[1] then return redis.call('del', KEYS[1]) else return 0 end";
    @Autowired
    private StringRedisTemplate redisTemplate;
    private RedisSerializer<String> stringRedisSerializer;

    public boolean lock(String key, long expiredTime, int retryTimes, long sleepMillis) {
        boolean result = this.lock(key, expiredTime);
        while (!result && retryTimes-- > 0) {
            try {
                logger.debug("lock failed, retrying..." + retryTimes);
                Thread.sleep(sleepMillis);
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
                return false;
            }
            result = this.lock(key, expiredTime);
        }
        return result;
    }

    public boolean lock(String key, long expiredTime) {
        String uuid = UUID.randomUUID().toString();
        this.lockValue.set(uuid);
        Boolean resultBoolean = (Boolean)this.redisTemplate.execute(connection -> {
            Object nativeConnection = connection.getNativeConnection();
            String redisResult = "";
            byte[] keyByte = this.stringRedisSerializer.serialize((Object)key);
            byte[] valueByte = this.stringRedisSerializer.serialize((Object)uuid);
            if (nativeConnection instanceof RedisAsyncCommands) {
                RedisAsyncCommands commands = (RedisAsyncCommands)nativeConnection;
                redisResult = commands.getStatefulConnection().sync().set((Object)keyByte, (Object)valueByte, SetArgs.Builder.nx().ex(expiredTime));
            }
            if (nativeConnection instanceof RedisAdvancedClusterAsyncCommands) {
                RedisAdvancedClusterAsyncCommands clusterAsyncCommands = (RedisAdvancedClusterAsyncCommands)nativeConnection;
                redisResult = clusterAsyncCommands.getStatefulConnection().sync().set((Object)keyByte, (Object)keyByte, SetArgs.Builder.nx().ex(expiredTime));
            }
            return LOCK_SUCCESS.equalsIgnoreCase(redisResult);
        });
        return resultBoolean != null && resultBoolean != false;
    }

    public boolean releaseLock(String key) {
        byte[] valueBytes;
        String lockValue = this.lockValue.get();
        if (lockValue == null) {
            return false;
        }
        byte[] keyBytes = this.stringRedisSerializer.serialize((Object)key);
        Long result = (Long)this.redisTemplate.execute(arg_0 -> this.lambda$releaseLock$1(keyBytes, valueBytes = this.stringRedisSerializer.serialize((Object)lockValue), arg_0));
        return result != null && result > 0L;
    }

    private Long getEvalResult(RedisFuture future) {
        try {
            Object o = future.get();
            return (Long)o;
        }
        catch (InterruptedException | ExecutionException e) {
            logger.error("Future get failed.", (Throwable)e);
            return 0L;
        }
    }

    public boolean isLocked(String key) {
        Object o = this.redisTemplate.opsForValue().get((Object)key);
        return o != null;
    }

    public void afterPropertiesSet() throws Exception {
        this.stringRedisSerializer = this.redisTemplate.getKeySerializer();
    }

    private /* synthetic */ Long lambda$releaseLock$1(byte[] keyBytes, byte[] valueBytes, RedisConnection connection) throws DataAccessException {
        Object nativeConnection = connection.getNativeConnection();
        if (nativeConnection instanceof RedisScriptingAsyncCommands) {
            RedisScriptingAsyncCommands command = (RedisScriptingAsyncCommands)nativeConnection;
            RedisFuture future = command.eval(UNLOCK_LUA, ScriptOutputType.INTEGER, new Object[]{keyBytes}, (Object[])new byte[][]{valueBytes});
            return this.getEvalResult(future);
        }
        logger.warn(REDIS_LIB_MISMATCH);
        return 0L;
    }
}

