/*
 * Decompiled with CFR 0.152.
 */
package cn.com.yusys.yusp.util;

import cn.com.yusys.yusp.util.FileUtilExt;
import com.jcraft.jsch.ChannelSftp;
import com.jcraft.jsch.JSch;
import com.jcraft.jsch.JSchException;
import com.jcraft.jsch.Session;
import com.jcraft.jsch.SftpException;
import java.io.File;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Properties;
import java.util.Vector;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.context.annotation.Lazy;
import org.springframework.context.annotation.Scope;
import org.springframework.stereotype.Component;

@Lazy(value=true)
@Component
@Scope(value="prototype")
public class SftpHandler {
    private Logger logger = LoggerFactory.getLogger(SftpHandler.class);
    private Session session = null;
    private ChannelSftp channel = null;
    @Value(value="${sftphandler.host}")
    private String host;
    @Value(value="${sftphandler.port}")
    private int port;
    @Value(value="${sftphandler.timeout}")
    private int timeout;
    @Value(value="${sftphandler.username}")
    private String username;
    @Value(value="${sftphandler.password}")
    private String password;
    @Value(value="${sftphandler.sftppath}")
    private String sftpPath;
    @Value(value="${sftphandler.localpath}")
    private String localpath;

    private SftpHandler() {
        System.out.println(this.toString());
    }

    public boolean login() {
        try {
            JSch jsch = new JSch();
            this.session = jsch.getSession(this.username, this.host, this.port);
            if (this.password != null) {
                this.session.setPassword(this.password);
            }
            Properties config = new Properties();
            config.put("StrictHostKeyChecking", "no");
            this.session.setConfig(config);
            this.session.setTimeout(this.timeout);
            this.session.connect();
            this.logger.debug("sftp session connected");
            this.logger.debug("opening channel");
            this.channel = (ChannelSftp)this.session.openChannel("sftp");
            this.channel.connect();
            this.logger.debug("connected successfully");
            return true;
        }
        catch (JSchException e) {
            this.logger.error("sftp login failed", (Throwable)e);
            if (this.channel != null) {
                this.channel.quit();
                this.channel.disconnect();
            }
            if (this.session != null) {
                this.session.disconnect();
            }
            return false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean uploadFile(String pathName, String fileName, InputStream input) {
        String currentDir = this.currentDir();
        if (!this.changeDir(pathName) && !this.mkdir(pathName)) {
            return false;
        }
        try {
            this.channel.put(input, fileName, 0);
            if (!this.existFile(fileName)) {
                this.logger.info("upload failed");
                boolean bl = false;
                return bl;
            }
            this.logger.info("upload successful");
            boolean bl = true;
            return bl;
        }
        catch (SftpException e) {
            this.logger.error("upload failed", (Throwable)e);
            boolean bl = false;
            return bl;
        }
        finally {
            this.changeDir(currentDir);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean uploadFile(String pathName, String fileName, String localFile) {
        String currentDir = this.currentDir();
        if (!this.changeDir(pathName)) {
            return false;
        }
        try {
            this.channel.put(localFile, fileName, 0);
            if (!this.existFile(fileName)) {
                this.logger.debug("upload failed");
                boolean bl = false;
                return bl;
            }
            this.logger.debug("upload successful");
            boolean bl = true;
            return bl;
        }
        catch (SftpException e) {
            this.logger.error("upload failed", (Throwable)e);
            boolean bl = false;
            return bl;
        }
        finally {
            this.changeDir(currentDir);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean downloadFile(String remotePath, String fileName, String localPath) {
        String currentDir = this.currentDir();
        if (!this.changeDir(remotePath)) {
            return false;
        }
        try {
            String localFilePath = localPath + File.separator + fileName;
            FileUtilExt.recursiveMkdirs(localFilePath);
            this.channel.get(fileName, localFilePath);
            File localFile = new File(localFilePath);
            if (!localFile.exists()) {
                this.logger.info("download file failed");
                boolean bl = false;
                return bl;
            }
            this.logger.info("download successful");
            boolean bl = true;
            return bl;
        }
        catch (SftpException e) {
            this.logger.error("download file failed", (Throwable)e);
            boolean bl = false;
            return bl;
        }
        finally {
            this.changeDir(currentDir);
        }
    }

    public boolean changeDir(String pathName) {
        if (pathName == null || pathName.trim().equals("")) {
            this.logger.debug("invalid pathName");
            return false;
        }
        try {
            this.channel.cd(pathName.replaceAll("\\\\", "/"));
            this.logger.debug("directory successfully changed,current dir=" + this.channel.pwd());
            return true;
        }
        catch (SftpException e) {
            this.logger.error("failed to change directory", (Throwable)e);
            return false;
        }
    }

    public boolean changeToParentDir() {
        return this.changeDir("..");
    }

    public boolean changeToHomeDir() {
        String homeDir = null;
        try {
            homeDir = this.channel.getHome();
        }
        catch (SftpException e) {
            this.logger.error("can not get home directory", (Throwable)e);
            return false;
        }
        return this.changeDir(homeDir);
    }

    public boolean makeDir(String dirName) {
        try {
            this.channel.mkdir(dirName);
            this.logger.debug("directory successfully created,dir=" + dirName);
            return true;
        }
        catch (SftpException e) {
            this.logger.error("failed to create directory", (Throwable)e);
            return false;
        }
    }

    public boolean delDir(String dirName) {
        if (!this.changeDir(dirName)) {
            return false;
        }
        Vector list = null;
        try {
            list = this.channel.ls(this.channel.pwd());
        }
        catch (SftpException e) {
            this.logger.error("can not list directory", (Throwable)e);
            return false;
        }
        for (ChannelSftp.LsEntry entry : list) {
            String fileName = entry.getFilename();
            if (fileName.equals(".") || fileName.equals("..")) continue;
            if (entry.getAttrs().isDir()) {
                this.delDir(fileName);
                continue;
            }
            this.delFile(fileName);
        }
        if (!this.changeToParentDir()) {
            return false;
        }
        try {
            this.channel.rmdir(dirName);
            this.logger.debug("directory " + dirName + " successfully deleted");
            return true;
        }
        catch (SftpException e) {
            this.logger.error("failed to delete directory " + dirName, (Throwable)e);
            return false;
        }
    }

    public boolean delFile(String fileName) {
        if (fileName == null || fileName.trim().equals("")) {
            this.logger.debug("invalid filename");
            return false;
        }
        try {
            this.channel.rm(fileName);
            this.logger.debug("file " + fileName + " successfully deleted");
            return true;
        }
        catch (SftpException e) {
            this.logger.error("failed to delete file " + fileName, (Throwable)e);
            return false;
        }
    }

    public String[] ls() {
        return this.list(Filter.ALL);
    }

    public String[] ls(String pathName) {
        String currentDir = this.currentDir();
        if (!this.changeDir(pathName)) {
            return new String[0];
        }
        String[] result = this.list(Filter.ALL);
        if (!this.changeDir(currentDir)) {
            return new String[0];
        }
        return result;
    }

    public String[] lsFiles() {
        return this.list(Filter.FILE);
    }

    public String[] lsFiles(String pathName) {
        String currentDir = this.currentDir();
        if (!this.changeDir(pathName)) {
            return new String[0];
        }
        String[] result = this.list(Filter.FILE);
        if (!this.changeDir(currentDir)) {
            return new String[0];
        }
        return result;
    }

    public String[] lsDirs() {
        return this.list(Filter.DIR);
    }

    public String[] lsDirs(String pathName) {
        String currentDir = this.currentDir();
        if (!this.changeDir(pathName)) {
            return new String[0];
        }
        String[] result = this.list(Filter.DIR);
        if (!this.changeDir(currentDir)) {
            return new String[0];
        }
        return result;
    }

    public boolean exist(String name) {
        return this.exist(this.ls(), name);
    }

    public boolean exist(String path, String name) {
        return this.exist(this.ls(path), name);
    }

    public boolean existFile(String name) {
        return this.exist(this.lsFiles(), name);
    }

    public boolean existFile(String path, String name) {
        return this.exist(this.lsFiles(path), name);
    }

    public boolean existDir(String name) {
        return this.exist(this.lsDirs(), name);
    }

    public boolean existDir(String path, String name) {
        return this.exist(this.lsDirs(path), name);
    }

    public String currentDir() {
        try {
            return this.channel.pwd();
        }
        catch (SftpException e) {
            this.logger.error("failed to get current dir", (Throwable)e);
            return this.homeDir();
        }
    }

    public boolean mkdir(String path) {
        boolean ret = true;
        String[] dirs = path.split("/");
        String tempPath = "";
        for (String dir : dirs) {
            if (null == dir || "".equals(dir)) continue;
            tempPath = tempPath + "/" + dir;
            this.logger.info("cheak dir [" + tempPath + "]");
            try {
                this.channel.cd(tempPath);
            }
            catch (SftpException e) {
                this.logger.info("mkdir dir [" + tempPath + "]");
                try {
                    this.channel.mkdir(tempPath);
                    this.logger.info("enter dir [" + tempPath + "]");
                    this.channel.cd(tempPath);
                }
                catch (SftpException e1) {
                    this.logger.error("mkdir error", (Throwable)e1);
                    ret = false;
                }
            }
        }
        return ret;
    }

    public void logout() {
        if (this.channel != null) {
            this.channel.quit();
            this.channel.disconnect();
        }
        if (this.session != null) {
            this.session.disconnect();
        }
        this.logger.debug("logout successfully");
    }

    private String[] list(Filter filter) {
        Vector list = null;
        try {
            list = this.channel.ls(this.channel.pwd());
        }
        catch (SftpException e) {
            this.logger.error("can not list directory", (Throwable)e);
            return new String[0];
        }
        ArrayList<String> resultList = new ArrayList<String>();
        for (ChannelSftp.LsEntry entry : list) {
            if (!this.filter(entry, filter)) continue;
            resultList.add(entry.getFilename());
        }
        return resultList.toArray(new String[0]);
    }

    private boolean filter(ChannelSftp.LsEntry entry, Filter f) {
        if (f.equals((Object)Filter.ALL)) {
            return !entry.getFilename().equals(".") && !entry.getFilename().equals("..");
        }
        if (f.equals((Object)Filter.FILE)) {
            return !entry.getFilename().equals(".") && !entry.getFilename().equals("..") && !entry.getAttrs().isDir();
        }
        if (f.equals((Object)Filter.DIR)) {
            return !entry.getFilename().equals(".") && !entry.getFilename().equals("..") && entry.getAttrs().isDir();
        }
        return false;
    }

    private String homeDir() {
        try {
            return this.channel.getHome();
        }
        catch (SftpException e) {
            return "/";
        }
    }

    private boolean exist(String[] strArr, String str) {
        if (strArr == null || strArr.length == 0) {
            return false;
        }
        if (str == null || str.trim().equals("")) {
            return false;
        }
        for (String s : strArr) {
            if (!s.equalsIgnoreCase(str)) continue;
            return true;
        }
        return false;
    }

    public String getHost() {
        return this.host;
    }

    public void setHost(String host) {
        this.host = host;
    }

    public int getPort() {
        return this.port;
    }

    public void setPort(int port) {
        this.port = port;
    }

    public int getTimeout() {
        return this.timeout;
    }

    public void setTimeout(int timeout) {
        this.timeout = timeout;
    }

    public String getUsername() {
        return this.username;
    }

    public void setUsername(String username) {
        this.username = username;
    }

    public String getPassword() {
        return this.password;
    }

    public void setPassword(String password) {
        this.password = password;
    }

    public String getSftpPath() {
        return this.sftpPath;
    }

    public void setSftpPath(String sftpPath) {
        this.sftpPath = sftpPath;
    }

    public String getLocalpath() {
        return this.localpath;
    }

    public void setLocalpath(String localpath) {
        this.localpath = localpath;
    }

    private static enum Filter {
        ALL,
        FILE,
        DIR;

    }
}

