/*
 * Decompiled with CFR 0.152.
 */
package cn.com.yusys.yusp.util;

import java.io.BufferedOutputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;

public class FileUtilExt {
    public static boolean recursiveRmFile(String fileName) {
        File[] files;
        File root = new File(fileName);
        if (!root.exists()) {
            return true;
        }
        if (root.isDirectory() && (files = root.listFiles()) != null) {
            for (int i = 0; i < files.length; ++i) {
                File file = files[i];
                if (file.isDirectory()) {
                    FileUtilExt.recursiveRmFile(file.getPath());
                    continue;
                }
                FileUtilExt.rmFile(file.getPath());
            }
        }
        return root.delete();
    }

    public static void recursiveMkdirs(String localPath) {
        File file = new File(localPath);
        if (!file.getParentFile().exists()) {
            file.getParentFile().mkdirs();
        }
    }

    public static boolean rmFile(String fileName) {
        File file = new File(fileName);
        if (!file.exists()) {
            return true;
        }
        return file.delete();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void writeFile(String localPath, byte[] content) throws IOException {
        File file = new File(localPath);
        if (!file.getParentFile().exists()) {
            file.getParentFile().mkdirs();
        }
        if (!file.exists()) {
            file.createNewFile();
        }
        try (OutputStream os = null;){
            os = new BufferedOutputStream(new FileOutputStream(localPath, false));
            os.write(content);
            os.flush();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void writeFile(String localPath, InputStream inputStream) throws IOException {
        File file = new File(localPath);
        if (!file.getParentFile().exists()) {
            file.getParentFile().mkdirs();
        }
        if (!file.exists()) {
            file.createNewFile();
        }
        try (OutputStream os = null;){
            os = new BufferedOutputStream(new FileOutputStream(localPath, false));
            byte[] buffer = new byte[4096];
            while (-1 != inputStream.read(buffer)) {
                os.write(buffer, 0, buffer.length);
            }
            os.flush();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static byte[] readFile(String localPath) throws Exception {
        FileInputStream in = null;
        ByteArrayOutputStream out = null;
        try {
            in = new FileInputStream(new File(localPath));
            out = new ByteArrayOutputStream();
            byte[] buffer = new byte[10240];
            int length = 0;
            while ((length = in.read(buffer, 0, buffer.length)) != -1) {
                out.write(buffer, 0, length);
            }
            byte[] byArray = out.toByteArray();
            return byArray;
        }
        finally {
            if (null != in) {
                in.close();
            }
            if (null != out) {
                out.close();
            }
        }
    }
}

