/*
 * Decompiled with CFR 0.152.
 */
package cn.com.yusys.yusp.util;

import cn.com.yusys.yusp.annotation.FieldAlias;
import cn.com.yusys.yusp.annotation.FieldType;
import cn.com.yusys.yusp.util.Invoke;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.beans.IntrospectionException;
import java.beans.PropertyDescriptor;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import net.sf.cglib.beans.BeanMap;
import org.apache.commons.lang.ArrayUtils;
import org.springframework.beans.BeanUtils;
import org.springframework.util.ClassUtils;

public class BeanUtilExt {
    private static Map<Class, List<Invoke>> cache = new ConcurrentHashMap<Class, List<Invoke>>();

    public static <T> Map<String, Object> toMap(T object) {
        List<Invoke> invokes = BeanUtilExt.getInvokesUseCache(object.getClass());
        if (invokes == null || invokes.isEmpty()) {
            return new HashMap<String, Object>(0);
        }
        HashMap<String, Object> data = new HashMap<String, Object>(invokes.size());
        try {
            for (Invoke invoke : invokes) {
                data.put(invoke.getKey(), invoke.getGetMethod().invoke(object, new Object[0]));
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new RuntimeException("invoke method fail,map to bean fail");
        }
        return data;
    }

    public static <T> T toBean(Map<String, Object> data, Class<T> tClass) {
        if (data == null || data.isEmpty()) {
            return null;
        }
        T object = BeanUtilExt.newInstance(tClass);
        List<Invoke> invokes = BeanUtilExt.getInvokesUseCache(object.getClass());
        if (invokes == null || invokes.isEmpty()) {
            return null;
        }
        for (Invoke invoke : invokes) {
            if (!data.containsKey(invoke.getKey()) || !invoke.getField().isAnnotationPresent(FieldAlias.class)) continue;
            FieldAlias fieldAlias = invoke.getField().getAnnotation(FieldAlias.class);
            String name = fieldAlias.fieldType().name();
            try {
                Class<?> curFieldType;
                if (name.equals(FieldType.BaseField.name())) {
                    curFieldType = invoke.getField().getType();
                    if (BeanUtilExt.isBaseType(curFieldType) || curFieldType.equals(Map.class)) {
                        invoke.getSetMethod().invoke(object, data.get(invoke.getKey()));
                        continue;
                    }
                    throw new RuntimeException("\u975e\u57fa\u672c\u6570\u636e\u7c7b\u578b\u6210\u5458\u5c5e\u6027");
                }
                if (name.equals(FieldType.ObjectField.name())) {
                    curFieldType = invoke.getField().getType();
                    if (BeanUtilExt.isBaseType(curFieldType) || curFieldType.equals(Map.class)) {
                        throw new RuntimeException("\u975e\u81ea\u5b9a\u4e49\u6210\u5458\u5c5e\u6027");
                    }
                    Object obj = BeanUtilExt.toBean((Map)data.get(invoke.getKey()), invoke.getField().getType());
                    invoke.getSetMethod().invoke(object, obj);
                    continue;
                }
                if (!name.equals(FieldType.ListField.name())) continue;
                invoke.getSetMethod().invoke(object, data.get(invoke.getKey()));
                curFieldType = invoke.getField().getType();
                if (curFieldType.equals(List.class)) {
                    Type genericType = invoke.getField().getGenericType();
                    ArrayList<T> tmp = new ArrayList<T>();
                    if (genericType != null && genericType instanceof ParameterizedType) {
                        ParameterizedType pt = (ParameterizedType)genericType;
                        Class actualTypeArgument = (Class)pt.getActualTypeArguments()[0];
                        List list = (List)data.get(invoke.getKey());
                        for (int i = 0; i < list.size(); ++i) {
                            T obj = BeanUtilExt.toBean((Map)list.get(i), actualTypeArgument);
                            tmp.add(obj);
                        }
                    }
                    invoke.getSetMethod().invoke(object, tmp);
                    continue;
                }
                throw new RuntimeException("\u975eList\u96c6\u5408\u6210\u5458\u5c5e\u6027");
            }
            catch (Exception e) {
                e.printStackTrace();
                throw new RuntimeException("invoke method fail");
            }
        }
        return object;
    }

    public static <T> T copyBean(Object source, Class<T> target) {
        T object = BeanUtilExt.newInstance(target);
        List<Invoke> invokes = BeanUtilExt.getInvokesUseCache(object.getClass());
        if (invokes == null || invokes.isEmpty()) {
            return null;
        }
        for (Invoke invoke : invokes) {
            Method readMethod;
            PropertyDescriptor sourcePd;
            Method writeMethod = invoke.getSetMethod();
            if (writeMethod == null || (sourcePd = BeanUtils.getPropertyDescriptor(source.getClass(), (String)invoke.getKey())) == null || (readMethod = sourcePd.getReadMethod()) == null || !ClassUtils.isAssignable(writeMethod.getParameterTypes()[0], readMethod.getReturnType())) continue;
            try {
                if (!Modifier.isPublic(readMethod.getDeclaringClass().getModifiers())) {
                    readMethod.setAccessible(true);
                }
                Object value = readMethod.invoke(source, new Object[0]);
                if (!Modifier.isPublic(writeMethod.getDeclaringClass().getModifiers())) {
                    writeMethod.setAccessible(true);
                }
                if (BeanUtilExt.isBaseType(invoke.getField().getType())) {
                    writeMethod.invoke(object, value);
                    continue;
                }
                if (invoke.getField().getType().equals(Map.class) || invoke.getField().getType().equals(List.class)) continue;
                Object obj = BeanUtilExt.copyBean(value, invoke.getField().getType());
                writeMethod.invoke(object, obj);
            }
            catch (Throwable ex) {
                throw new RuntimeException("Could not copy property '" + invoke.getKey() + "' from source to target", ex);
            }
        }
        return object;
    }

    private static List<Invoke> getInvokesUseCache(Class clazz) {
        List<Invoke> invokes;
        if (cache.containsKey(clazz)) {
            invokes = cache.get(clazz);
        } else {
            invokes = BeanUtilExt.getInvokes(clazz);
            cache.put(clazz, invokes);
        }
        return invokes;
    }

    private static List<Invoke> getInvokes(Class clazz) {
        Field[] declaredFields;
        ArrayList<Invoke> invokes = new ArrayList<Invoke>(2);
        for (Field field : declaredFields = clazz.getDeclaredFields()) {
            PropertyDescriptor descriptor;
            Invoke invoke = new Invoke();
            invoke.setField(field);
            if (field.isAnnotationPresent(FieldAlias.class)) {
                FieldAlias field2Map = field.getAnnotation(FieldAlias.class);
                String alias = field2Map.alias();
                if (alias != null && !alias.equals("")) {
                    invoke.setKey(alias);
                } else {
                    invoke.setKey(field.getName());
                }
            } else {
                invoke.setKey(field.getName());
            }
            try {
                descriptor = new PropertyDescriptor(field.getName(), clazz);
            }
            catch (IntrospectionException e) {
                continue;
            }
            invoke.setGetMethod(descriptor.getReadMethod());
            invoke.setSetMethod(descriptor.getWriteMethod());
            invokes.add(invoke);
        }
        return invokes;
    }

    private static boolean isBaseType(Class clazz) {
        return clazz.equals(Integer.class) || clazz.equals(String.class) || clazz.equals(Float.class) || clazz.equals(Double.class) || clazz.equals(Short.class) || clazz.equals(Byte.class) || clazz.equals(Boolean.class) || clazz.equals(Character.class) || clazz.equals(Integer.class) || clazz.equals(Integer.class);
    }

    private static <T> T newInstance(Class<T> clazz) {
        T object = null;
        try {
            object = clazz.newInstance();
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new RuntimeException("Could not new instance object:" + clazz.getName(), e);
        }
        return object;
    }

    public static void copyBean(Object source, Object target, String ... ignoreProperties) {
        if (ArrayUtils.isEmpty((Object[])ignoreProperties)) {
            BeanUtils.copyProperties((Object)source, (Object)target);
        } else {
            BeanUtils.copyProperties((Object)source, (Object)target, (String[])ignoreProperties);
        }
    }

    public static <T> T copyBean(Object source, Class<T> target, String ... ignoreProperties) {
        T targetInstance = null;
        try {
            targetInstance = target.newInstance();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        if (ArrayUtils.isEmpty((Object[])ignoreProperties)) {
            BeanUtils.copyProperties((Object)source, targetInstance);
        } else {
            BeanUtils.copyProperties((Object)source, targetInstance, (String[])ignoreProperties);
        }
        return targetInstance;
    }

    public static <T, E> List<T> copyList(List<E> list, Class<T> target, String ... ignoreProperties) {
        ArrayList<T> targetList = new ArrayList<T>();
        if (list == null || list.isEmpty()) {
            return targetList;
        }
        for (E e : list) {
            targetList.add(BeanUtilExt.copyBean(e, target, ignoreProperties));
        }
        return targetList;
    }

    public static <T> Map<String, Object> bean2Map(T bean) {
        HashMap map = Maps.newHashMap();
        if (bean != null) {
            BeanMap beanMap = BeanMap.create(bean);
            for (Object key : beanMap.keySet()) {
                map.put(key + "", beanMap.get(key));
            }
        }
        return map;
    }

    public static <T> Map<String, Object> bean2Map(T bean, Map<String, Object> map) {
        if (bean != null && map != null) {
            BeanMap beanMap = BeanMap.create(bean);
            for (Object key : beanMap.keySet()) {
                map.put(key + "", beanMap.get(key));
            }
        }
        return map;
    }

    public static <T> T map2Bean(Map<String, Object> map, T bean) {
        BeanMap beanMap = BeanMap.create(bean);
        beanMap.putAll(map);
        return bean;
    }

    public static <T> List<Map<String, Object>> objectsToMaps(List<T> objList) {
        ArrayList list = Lists.newArrayList();
        if (objList != null && objList.size() > 0) {
            Map<String, Object> map = null;
            T bean = null;
            int size = objList.size();
            for (int i = 0; i < size; ++i) {
                bean = objList.get(i);
                map = BeanUtilExt.bean2Map(bean);
                list.add(map);
            }
        }
        return list;
    }

    public static <T> List<T> mapsToObjects(List<Map<String, Object>> maps, Class<T> clazz) {
        ArrayList list = Lists.newArrayList();
        if (maps != null && maps.size() > 0) {
            Map<String, Object> map = null;
            Object bean = null;
            int size = maps.size();
            for (int i = 0; i < size; ++i) {
                map = maps.get(i);
                try {
                    bean = clazz.newInstance();
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
                BeanUtilExt.map2Bean(map, bean);
                list.add(bean);
            }
        }
        return list;
    }
}

