/*
 * Decompiled with CFR 0.152.
 */
package cn.com.yusys.yusp.annotation;

import java.lang.annotation.ElementType;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import javax.validation.Constraint;
import javax.validation.ConstraintValidator;
import javax.validation.ConstraintValidatorContext;
import javax.validation.Payload;

@Target(value={ElementType.METHOD, ElementType.FIELD, ElementType.ANNOTATION_TYPE})
@Retention(value=RetentionPolicy.RUNTIME)
@Constraint(validatedBy={EnumValidator.class})
public @interface EnumValid {
    public String message() default "{enum.value.invalid}";

    public Class<?>[] groups() default {};

    public Class<? extends Payload>[] payload() default {};

    public Class<? extends Enum<?>> enumClass();

    public String enumMethod() default "isValidEnum";

    public boolean allowNull() default false;

    public static class EnumValidator
    implements ConstraintValidator<EnumValid, Object> {
        private Class<? extends Enum<?>> enumClass;
        private String enumMethod;
        private boolean allowNull;

        public void initialize(EnumValid enumValue) {
            this.enumMethod = enumValue.enumMethod();
            this.enumClass = enumValue.enumClass();
            this.allowNull = enumValue.allowNull();
        }

        public boolean isValid(Object value, ConstraintValidatorContext constraintValidatorContext) {
            if (value == null || "".equals(value)) {
                return this.allowNull;
            }
            if (this.enumClass == null || this.enumMethod == null) {
                return Boolean.TRUE;
            }
            Class<?> valueClass = value.getClass();
            try {
                Method method = this.enumClass.getMethod(this.enumMethod, valueClass);
                if (!Boolean.TYPE.equals(method.getReturnType()) && !Boolean.class.equals(method.getReturnType())) {
                    throw new RuntimeException(String.format("%s method return is not boolean type in the %s class", this.enumMethod, this.enumClass));
                }
                if (!Modifier.isStatic(method.getModifiers())) {
                    throw new RuntimeException(String.format("%s method is not static method in the %s class", this.enumMethod, this.enumClass));
                }
                Boolean result = (Boolean)method.invoke(null, value);
                return result == null ? Boolean.FALSE : result;
            }
            catch (IllegalAccessException | IllegalArgumentException | InvocationTargetException e) {
                throw new RuntimeException(e);
            }
            catch (NoSuchMethodException | SecurityException e) {
                throw new RuntimeException(String.format("This %s(%s) method does not exist in the %s", this.enumMethod, valueClass, this.enumClass), e);
            }
        }
    }
}

