/*
 * Decompiled with CFR 0.152.
 */
package cn.com.yusys.yusp.service;

import cn.com.yusys.yusp.app.oca.domain.AdminSmOrg;
import cn.com.yusys.yusp.app.oca.domain.AdminSmRole;
import cn.com.yusys.yusp.app.oca.domain.AdminSmUser;
import cn.com.yusys.yusp.app.oca.dto.UserDTO;
import cn.com.yusys.yusp.commons.web.rest.dto.ResultDto;
import cn.com.yusys.yusp.service.UserProviderServiceHystrix;
import java.util.List;
import java.util.Map;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestParam;

@FeignClient(fallback=UserProviderServiceHystrix.class, name="${service.feignclient.name.sp-app-oca:sp-app-oca}", path="/api")
public interface UserProviderService {
    @GetMapping(value={"/user/org/{orgId}"})
    public List<String> queryUserByOrgId(@PathVariable(value="orgId") String var1);

    @PostMapping(value={"/user/orgs"})
    public List<String> queryUserByOrgIds(@RequestBody List<String> var1);

    @GetMapping(value={"/user/role/{roleId}"})
    public List<String> queryUserByRoleId(@PathVariable(value="roleId") String var1);

    @GetMapping(value={"/user/duty/{dutyId}"})
    public List<String> queryUserByDutyId(@PathVariable(value="dutyId") String var1);

    @GetMapping(value={"/org/user/{userId}"})
    public List<String> queryOrgsByUserId(@PathVariable(value="userId") String var1);

    @GetMapping(value={"/org/logincode/{loginCode}"})
    public List<String> queryOrgsByLoginCode(@PathVariable(value="loginCode") String var1);

    @GetMapping(value={"/org/uporg/{upOrgId}"})
    public List<String> queryOrgsByUpOrgId(@PathVariable(value="upOrgId") String var1);

    @GetMapping(value={"/uporg/org/{orgId}"})
    public List<String> queryUpOrgByOrgId(@PathVariable(value="orgId") String var1);

    @GetMapping(value={"/uporg/queryOrgByOrgIds"})
    public List<String> queryOrgByOrgIds(@RequestParam(value="orgIds") List<String> var1);

    @GetMapping(value={"/user/{userId}"})
    public UserDTO queryUserInfoByUserId(@PathVariable(value="userId") String var1);

    @GetMapping(value={"/user/queryByUserCode"})
    public List<Map<String, Object>> queryByUserCode(@RequestParam(value="userCodes") List<String> var1);

    @GetMapping(value={"/user/queryByBankOrgId"})
    public List<Map<String, Object>> queryByBankOrgId(@RequestParam(value="bankOrgId") String var1);

    @GetMapping(value={"/org/queryByOrgCode"})
    public List<Map<String, Object>> queryByOrgCode(@RequestParam(value="orgCodes") List<String> var1);

    @GetMapping(value={"/role/queryByRoleCode"})
    public List<Map<String, Object>> queryByRoleCode(@RequestParam(value="roleCodes") List<String> var1);

    @GetMapping(value={"/duty/queryByDutyCode"})
    public List<Map<String, Object>> queryByDutyCode(@RequestParam(value="dutyCodes") List<String> var1);

    @GetMapping(value={"/user/role/query/{roleCode}"})
    public List<String> queryUserByRoleCode(@PathVariable(value="roleCode") String var1);

    @GetMapping(value={"/user/duty/query/{dutyCode}"})
    public List<String> queryUserByDutyCode(@PathVariable(value="dutyCode") String var1);

    @GetMapping(value={"/user/query/{orgId}"})
    public List<String> queryUserCodeByOrgId(@PathVariable(value="orgId") String var1);

    @GetMapping(value={"/user/uporg/query/{orgId}"})
    public List<String> queryUpOrgUserByOrg(@PathVariable(value="orgId") String var1);

    @GetMapping(value={"/util/getUserCodebyOrgCode"})
    public List<String> getUserCodebyOrgCode(@RequestParam(value="orgCodes") List<String> var1);

    @GetMapping(value={"/util/getUserCodebyRoleCode"})
    public List<String> getUserCodebyRoleCode(@RequestParam(value="roleCodes") List<String> var1);

    @GetMapping(value={"/util/getUserCodebyDutyCde"})
    public List<String> getUserCodebyDutyCde(@RequestParam(value="dutyCdes") List<String> var1);

    @GetMapping(value={"/adminsmonline/queryByLoginCode"})
    public ResultDto<List<Map<String, Object>>> queryByLoginCode(@RequestParam(value="loginCode") String var1);

    @GetMapping(value={"/adminsmrole/getUserByRO"})
    public List<AdminSmUser> getUserByRO(@RequestParam(value="roleIds") String var1, @RequestParam(value="orgId") String var2);

    @PostMapping(value={"/adminsmrolemod/queryRoleInfoByModId"})
    public List<AdminSmRole> queryRoleInfoByModId(@RequestParam(value="modId") String var1);

    @GetMapping(value={"/adminsmorg/querySalesDepartment"})
    public List<AdminSmOrg> querySalesDepartment(@RequestParam(value="userId") String var1);

    @GetMapping(value={"/adminsmorg/querySalesDepartmentByOrgId"})
    public List<AdminSmOrg> querySalesDepartmentByOrgId(@RequestParam(value="orgId") String var1);
}

