package cn.com.yusys.yusp.service;

import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;

import cn.com.yusys.yusp.AdminSmVerifyCode;
import cn.com.yusys.yusp.VerifyCodeReqDto;
import cn.com.yusys.yusp.VerifyCodeResDto;
import cn.com.yusys.yusp.commons.web.rest.dto.ResultDto;

/**
 * @author 102661
 * @date 2020/01/02
 */
@FeignClient(fallback = VerifyCodeProviderServiceHystrix.class, name = "${service.feignclient.name.sp-app-common:sp-app-common}", path = "/api/adminsmverifycode")
public interface VerifyCodeProviderService {

	/**
	 * 生成验证码(时效，密码位数,手机号,短信模板)
	 * 
	 * @param map
	 * @return
	 */
	@PostMapping("/createCode")
	ResultDto<VerifyCodeResDto> createCode(@RequestBody VerifyCodeReqDto verifyCodeReqDto);

	/**
	 * 验证验证码
	 * 
	 * @param map
	 * @return
	 */
	@PostMapping("/checkCode")
	ResultDto<Object> checkCode(@RequestBody AdminSmVerifyCode adminSmVerifyCode);
}
