package cn.com.yusys.yusp.service;

import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;

import cn.com.yusys.yusp.SysTaskDto;
import cn.com.yusys.yusp.SysTaskFeedbackDto;
import cn.com.yusys.yusp.commons.web.rest.dto.ResultDto;

@FeignClient(fallback=SysTaskClientHystrix.class  ,name = "${service.feignclient.name.sp-app-common:sp-app-common}", path = "/api/systask")
public interface SysTaskClient {
	
	
	/**
	 * 任务新增
	 * @param  
	 * @return
	 */
	@RequestMapping(value = "/create", method = RequestMethod.POST)
	public ResultDto<SysTaskDto> create(@RequestBody SysTaskDto sysTaskDto);
	
	/**
	 * 任务反馈新增
	 * @param  
	 * @return
	 */
	@RequestMapping(value = "/createFeedBack", method = RequestMethod.POST)
	public ResultDto<Integer> createFeedBack(@RequestBody SysTaskFeedbackDto sysTaskFeedbackDto);
	
	/**
	 * 修改
	 * @param  
	 * @return
	 */
//	@RequestMapping(value = "/update", method = RequestMethod.POST)
//	public ResultDto<Integer> update(@RequestBody SysTaskDto sysTask);
	
	/**
	 * 删除
	 * @param 
	 * @return
	 */
//	@RequestMapping(value = "/delete", method = RequestMethod.POST)
//	public ResultDto<Integer> delete(@RequestBody SysTaskDto sysTask);
	
	
	/**
	 * 查询
	 * @param  
	 * @return
	 */
//	@RequestMapping(value = "/querypage", method = RequestMethod.POST)
//	public ResultDto<List<Map<String,String>>> querypage(QueryModel model);
}
