package cn.com.yusys.yusp.service;

import cn.com.yusys.yusp.commons.web.rest.dto.ResultDto;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.web.bind.annotation.*;
import cn.com.yusys.yusp.Calendar;

import java.util.List;


/**
 * @author 102661
 * @date 2020/01/13
 */

@FeignClient(fallback = CalendarClientHystrix.class, name = "sp-app-common", path = "/api/calendar")
public interface CalendarClient {

    /**
     * @函数名称:get
     * @函数描述:查询单个对象，公共API接口
     * @参数与返回说明:
     * @算法描述:
     */
    @GetMapping("/{id}")
    ResultDto<Calendar> get(@PathVariable("id") String id);

    /**
     * @param module
     * @param orgId
     * @param isWorking
     * @param startDate
     * @param endDate
     * @param page
     * @param size
     * @return
     */
    @GetMapping("/")
    ResultDto<List<Calendar>> list(@RequestParam("module") String module, @RequestParam("orgId") String orgId, @RequestParam("isWorking") String isWorking, @RequestParam("startDate") String startDate, @RequestParam("endDate") String endDate, @RequestParam(value = "page", defaultValue = "1") int page, @RequestParam(value = "size", defaultValue = "366") int size);

    /**
     * @函数名称:create
     * @函数描述:实体类创建，公共API接口
     * @参数与返回说明:
     * @算法描述:
     */
    @PostMapping("/")
    ResultDto<Calendar> create(@RequestBody Calendar calendar);


    /**
     * @函数名称:update
     * @函数描述:对象修改，公共API接口
     * @参数与返回说明:
     * @算法描述:
     */
    @PostMapping("/update")
    ResultDto<Integer> update(@RequestBody Calendar calendar);

}
