/*
 * Decompiled with CFR 0.152.
 */
package cn.com.yusys.yusp.front.parm.domain.repo;

import cn.com.yusys.yusp.commons.util.date.DateUtils;
import cn.com.yusys.yusp.front.parm.dao.mapper.DynamicSqlMapper;
import cn.com.yusys.yusp.front.parm.domain.vo.PlatDateInfo;
import java.util.Date;
import java.util.Locale;
import java.util.Map;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Component;

@Component
public class InitFlatDateRepo {
    @Autowired
    private DynamicSqlMapper dynamicSqlMapper;
    @Value(value="${front.datatype}")
    private String datatype;

    public String getDatatype() {
        return this.datatype;
    }

    public void setDatatype(String datatype) {
        this.datatype = datatype;
    }

    public PlatDateInfo getDateTime() {
        String sql = "";
        String workdate = "";
        String worktime = "";
        String strIsoDateTime = "";
        String strtimesp = "";
        Locale.setDefault(Locale.ENGLISH);
        if ("mysql".equals(this.datatype.toLowerCase())) {
            sql = "select current_timestamp as sysdate,date_format(current_timestamp(3),'%Y-%m-%dT%T:%f') as timesp";
            Map<String, Object> result = this.dynamicSqlMapper.executeQueryMap(sql);
            Date date = DateUtils.parseDate((String)result.get("sysdate").toString().replace("T", " "), (String)"yyyy-MM-dd HH:mm:ss");
            System.out.println(result.toString());
            System.out.println(result.get("sysdate").toString());
            System.out.printf(DateUtils.formatDate((Date)date, (String)"yyyyMMdd"), new Object[0]);
            workdate = DateUtils.formatDate((Date)date, (String)"yyyyMMdd");
            worktime = DateUtils.formatDate((Date)date, (String)"HHmmss");
            strIsoDateTime = DateUtils.formatDate((Date)date, (String)"yyyy-MM-dd") + "T" + DateUtils.formatDate((Date)date, (String)"HH:mm:ss");
            strtimesp = result.get("timesp").toString();
        } else if ("oracle".equals(this.datatype.toLowerCase())) {
            sql = "select sysdate,to_char(systimestamp,'yyyy-mm-dd hh24:mi:ssxff') as timesp from dual";
            Map<String, Object> result = this.dynamicSqlMapper.executeQueryMap(sql);
            Date date = DateUtils.parseDate((String)result.get("sysdate").toString(), (String)"yyyy-MM-dd HH:mm:ss");
            workdate = DateUtils.formatDate((Date)date, (String)"yyyyMMdd");
            worktime = DateUtils.formatDate((Date)date, (String)"HHmmss");
            strtimesp = result.get("timesp").toString();
            strIsoDateTime = DateUtils.formatDate((Date)date, (String)"yyyy-MM-dd") + "T" + DateUtils.formatDate((Date)date, (String)"HH:mm:ss");
        } else if ("db2".equals(this.datatype.toLowerCase())) {
            sql = "select CURRENT DATE as date,CURRENT TIME as time,current timestamp as timesp from SYSIBM.SYSDUMMY1";
            Map<String, Object> result = this.dynamicSqlMapper.executeQueryMap(sql);
            workdate = result.get("date").toString().replace("-", "");
            worktime = result.get("time").toString().replace(":", "");
            strtimesp = result.get("timesp").toString();
            strIsoDateTime = result.get("date").toString() + "T" + result.get("time").toString();
        } else {
            workdate = DateUtils.formatDate((Date)new Date(), (String)"yyyyMMdd");
            worktime = DateUtils.formatDate((Date)new Date(), (String)"HHmmss");
            strtimesp = DateUtils.formatDate((Date)new Date(), (String)"yyyy-MM-dd HH:mm:ss");
            strIsoDateTime = DateUtils.formatDate((Date)new Date(), (String)"yyyy-MM-dd") + "T" + DateUtils.formatDate((Date)new Date(), (String)"HH:mm:ss");
        }
        return new PlatDateInfo(workdate, worktime, strIsoDateTime, strtimesp);
    }
}

