/*
 * Decompiled with CFR 0.152.
 */
package cn.com.yusys.yusp.front.host.domain.repo;

import cn.com.yusys.yusp.bsp.communication.BspTemplate;
import cn.com.yusys.yusp.front.common.util.YuinLogUtils;
import cn.com.yusys.yusp.front.host.dao.po.UcPCominfoPo;
import cn.com.yusys.yusp.front.host.domain.repo.UcPCominfoRepo;
import cn.com.yusys.yusp.front.host.domain.vo.CorpReqCommInfo;
import cn.com.yusys.yusp.front.host.domain.vo.HostReqCommInfo;
import cn.com.yusys.yusp.front.host.domain.vo.RspCommInfo;
import cn.com.yusys.yusp.front.host.domain.vo.UcPCominfoQueryVo;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Resource;
import org.apache.commons.lang.math.RandomUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

@Component
public class UcCommServiceRepo {
    private static final Logger loger = LoggerFactory.getLogger(UcCommServiceRepo.class);
    @Resource
    private UcPCominfoRepo ucPCominfoRepo;

    public RspCommInfo corpCommon(CorpReqCommInfo hostCommInfo) {
        String sysid = hostCommInfo.getSysid();
        String appid = hostCommInfo.getAppid();
        String commid = hostCommInfo.getHostcommid();
        String bspno = hostCommInfo.getBspno();
        String url = hostCommInfo.getUrl();
        YuinLogUtils.getInst(this).info("sysid:" + sysid);
        YuinLogUtils.getInst(this).info("appid:" + appid);
        YuinLogUtils.getInst(this).info("commid:" + commid);
        YuinLogUtils.getInst(this).info("bspno:" + bspno);
        Map<String, Object> sender = hostCommInfo.getSender();
        RspCommInfo rspCommInfo = new RspCommInfo();
        HashMap<String, Object> info = new HashMap<String, Object>();
        UcPCominfoPo UcPCominfoPo2 = this.getComminfo(sysid, appid, commid, bspno);
        if (UcPCominfoPo2 == null) {
            rspCommInfo.setErrcode("__CORP002__");
            rspCommInfo.setErrmsg("\u83b7\u53d6\u901a\u8baf\u914d\u7f6e\u5f02\u5e38:" + hostCommInfo.toString());
            return rspCommInfo;
        }
        info.put("corp_ip", UcPCominfoPo2.getComip());
        info.put("corp_port", UcPCominfoPo2.getComport());
        info.put("corp_url", url);
        info.put("tradeDataMap", sender);
        YuinLogUtils.getInst(this).info("hostip:" + UcPCominfoPo2.getComip());
        YuinLogUtils.getInst(this).info("hostport:" + UcPCominfoPo2.getComport());
        YuinLogUtils.getInst(this).info("corpurl:" + url);
        YuinLogUtils.getInst(this).info("tradeSendDataMap:" + sender);
        try {
            Map result = BspTemplate.exchange((String)"corpOut", info);
            YuinLogUtils.getInst(this).info("tradeRecvDataMap:" + result);
            Map recvData = result.getOrDefault("recvData", new HashMap());
            rspCommInfo.setErrcode(recvData.getOrDefault("errcode", "").toString());
            rspCommInfo.setRecv(recvData);
            rspCommInfo.setErrmsg(recvData.getOrDefault("errmsg", "").toString());
        }
        catch (Exception e) {
            e.printStackTrace();
            loger.error("\u6838\u5fc3\u901a\u8baf\u5f02\u5e38", (Throwable)e);
            rspCommInfo.setErrcode("__CORP001__");
            rspCommInfo.setErrmsg(e.getMessage());
        }
        return rspCommInfo;
    }

    public RspCommInfo hostCommon(HostReqCommInfo hostCommInfo) {
        YuinLogUtils.getInst(this).info("\u6838\u5fc3\u901a\u8baf\u5f00\u59cb");
        String sysid = hostCommInfo.getSysid();
        String appid = hostCommInfo.getAppid();
        String commid = hostCommInfo.getHostcommid();
        String bspno = hostCommInfo.getBspno();
        String url = hostCommInfo.getUrl();
        YuinLogUtils.getInst(this).info("sysid:" + sysid);
        YuinLogUtils.getInst(this).info("appid:" + appid);
        YuinLogUtils.getInst(this).info("commid:" + commid);
        YuinLogUtils.getInst(this).info("bspno:" + bspno);
        Map<String, Object> sender = hostCommInfo.getSender();
        RspCommInfo rspCommInfo = new RspCommInfo();
        HashMap<String, Object> info = new HashMap<String, Object>();
        UcPCominfoPo UcPCominfoPo2 = this.getComminfo(sysid, appid, commid, bspno);
        if (UcPCominfoPo2 == null) {
            rspCommInfo.setErrcode("__HOST002__");
            rspCommInfo.setErrmsg("\u83b7\u53d6\u901a\u8baf\u914d\u7f6e\u4fe1\u606f\u5f02\u5e38");
            return rspCommInfo;
        }
        info.put("hostip", UcPCominfoPo2.getComip());
        info.put("hostport", UcPCominfoPo2.getComport());
        info.put("hosturl", url);
        info.put("tradeDataMap", sender);
        YuinLogUtils.getInst(this).info("hostip:" + UcPCominfoPo2.getComip());
        YuinLogUtils.getInst(this).info("hostport:" + UcPCominfoPo2.getComport());
        YuinLogUtils.getInst(this).info("hosturl:" + url);
        YuinLogUtils.getInst(this).info("tradeSendDataMap:" + sender);
        try {
            YuinLogUtils.getInst(this).info("hostip:" + UcPCominfoPo2.getComip());
            Map result = BspTemplate.exchange((String)"hostOut", info);
            YuinLogUtils.getInst(this).info("tradeRecvDataMap:" + result);
            Map recvData = result.getOrDefault("recvData", new HashMap());
            rspCommInfo.setErrcode(recvData.getOrDefault("errcode", "").toString());
            rspCommInfo.setRecv(recvData);
            rspCommInfo.setErrmsg(recvData.getOrDefault("errmsg", "").toString());
        }
        catch (Exception e) {
            e.printStackTrace();
            loger.error("\u6838\u5fc3\u901a\u8baf\u5f02\u5e38", (Throwable)e);
            rspCommInfo.setErrcode("__HOST001__");
            rspCommInfo.setErrmsg(e.getMessage());
        }
        return rspCommInfo;
    }

    public RspCommInfo registerReverse(HostReqCommInfo hostCommInfo) {
        return null;
    }

    public RspCommInfo suspenseCommon(HostReqCommInfo hostCommInfo) {
        return null;
    }

    public UcPCominfoPo getComminfo(String sysid, String appid, String commid, String bspno) {
        UcPCominfoQueryVo ucPCominfoQueryVo = new UcPCominfoQueryVo();
        ucPCominfoQueryVo.setAppid(appid);
        ucPCominfoQueryVo.setSysid(sysid);
        ucPCominfoQueryVo.setComid(commid);
        ucPCominfoQueryVo.setEffectflag("1");
        ucPCominfoQueryVo.setStatus("1");
        ucPCominfoQueryVo.setBspno(bspno);
        List<UcPCominfoPo> cominfolist = this.ucPCominfoRepo.listData(ucPCominfoQueryVo);
        if (cominfolist == null || cominfolist.size() == 0) {
            UcPCominfoQueryVo ucPCominfoQueryVo1 = new UcPCominfoQueryVo();
            ucPCominfoQueryVo1.setAppid(appid);
            ucPCominfoQueryVo1.setSysid(sysid);
            ucPCominfoQueryVo1.setComid(commid);
            ucPCominfoQueryVo1.setDefaultflag("1");
            cominfolist = this.ucPCominfoRepo.listDefaultData(ucPCominfoQueryVo1);
            if (cominfolist == null || cominfolist.size() == 0) {
                loger.error("\u83b7\u53d6\u901a\u8baf\u914d\u7f6e\u4fe1\u606f\u5f02\u5e38");
                return null;
            }
        }
        ArrayList last = new ArrayList();
        cominfolist.forEach(UcPCominfoPo2 -> {
            String strsysid = UcPCominfoPo2.getSysid();
            String strappid = UcPCominfoPo2.getAppid();
            int flag = 0;
            if (!"PUB".equals(strsysid) && !"PUB".equals(strappid)) {
                if (flag > 1 && last.size() > 0) {
                    last.clear();
                }
                last.add(UcPCominfoPo2);
                flag = 1;
            } else if (!"PUB".equals(strsysid) && "PUB".equals(strappid)) {
                if (flag > 2 && last.size() > 0) {
                    last.clear();
                }
                last.add(UcPCominfoPo2);
                flag = 2;
            } else {
                if (flag > 3 && last.size() > 0) {
                    last.clear();
                }
                last.add(UcPCominfoPo2);
                flag = 3;
            }
        });
        if (last.size() > 0) {
            if (last.size() == 1) {
                return (UcPCominfoPo)last.get(0);
            }
            return (UcPCominfoPo)last.get(RandomUtils.nextInt((int)last.size()));
        }
        return null;
    }
}

