/*
 * Decompiled with CFR 0.152.
 */
package cn.com.yusys.yusp.front.common.util;

import java.util.HashMap;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class YuinLogUtils {
    private static String logPrefix = "yusp-front-common-log -> ";
    private static YuinLogUtils instance;
    private static Logger logger;
    private static Map<Class, Logger> loggerList;

    private YuinLogUtils() {
    }

    public static synchronized YuinLogUtils getInst(Object obj) {
        if (instance == null) {
            instance = new YuinLogUtils();
        }
        if ((logger = loggerList.get(obj.getClass())) == null) {
            logger = LoggerFactory.getLogger(obj.getClass());
            loggerList.put(obj.getClass(), logger);
        }
        return instance;
    }

    public static synchronized YuinLogUtils getInst(Class clazz) {
        if (instance == null) {
            instance = new YuinLogUtils();
        }
        if ((logger = loggerList.get(clazz)) == null) {
            logger = LoggerFactory.getLogger((Class)clazz);
            loggerList.put(clazz, logger);
        }
        return instance;
    }

    public static synchronized YuinLogUtils getInst() {
        if (instance == null) {
            instance = new YuinLogUtils();
        }
        if ((logger = loggerList.get(YuinLogUtils.class)) == null) {
            logger = LoggerFactory.getLogger(YuinLogUtils.class);
            loggerList.put(YuinLogUtils.class, logger);
        }
        return instance;
    }

    public void trace(String message) {
        logger.trace(logPrefix + message);
    }

    public void trace(String message, Throwable t) {
        logger.trace(logPrefix + message, t);
    }

    public void debug(String message) {
        logger.debug(logPrefix + message);
    }

    public void debug(String message, Throwable t) {
        logger.debug(logPrefix + message, t);
    }

    public void info(String message) {
        logger.info(logPrefix + message);
    }

    public void info(String message, Throwable t) {
        logger.info(logPrefix + message, t);
    }

    public void warn(String message) {
        logger.warn(logPrefix + message);
    }

    public void warn(String message, Throwable t) {
        logger.warn(logPrefix + message, t);
    }

    public void error(String message, Object ... arguments) {
        logger.error(logPrefix + message, arguments);
    }

    public void error(String message, Throwable t, Object ... arguments) {
        logger.error(logPrefix + message, (Object)t, (Object)arguments);
    }

    static {
        logger = null;
        loggerList = new HashMap<Class, Logger>();
    }
}

