/*
 * Decompiled with CFR 0.152.
 */
package cn.com.yusys.yusp.front.common.util;

import java.time.Duration;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.redis.core.ListOperations;
import org.springframework.data.redis.core.RedisTemplate;
import org.springframework.data.redis.core.ValueOperations;
import org.springframework.stereotype.Component;

@Component
public class RedisUtil {
    @Autowired
    private RedisTemplate redisTemplate;

    public void delete(String key) {
        this.redisTemplate.delete((Object)key);
    }

    public void deleteKey(String ... keys) {
        this.redisTemplate.delete((Object)keys);
    }

    public Long delete(List<String> keyList) {
        return this.redisTemplate.delete(keyList);
    }

    public Long delete(Set<String> keyList) {
        return this.redisTemplate.delete(keyList);
    }

    public void expire(String key, long time) {
        this.redisTemplate.expire((Object)key, time, TimeUnit.MINUTES);
    }

    public long getExpire(String key) {
        Long expire = this.redisTemplate.getExpire((Object)key);
        return expire;
    }

    public boolean hasKey(String key) {
        return this.redisTemplate.hasKey((Object)key);
    }

    public void addValue(String key, Object obj, int minutes) {
        ValueOperations ops = this.redisTemplate.opsForValue();
        ops.set((Object)key, obj, (long)minutes, TimeUnit.MINUTES);
    }

    public void addValue(String key, Object obj) {
        ValueOperations ops = this.redisTemplate.opsForValue();
        ops.set((Object)key, obj, -1L, TimeUnit.MINUTES);
    }

    public Object get(String key) {
        return key == null ? null : this.redisTemplate.opsForValue().get((Object)key);
    }

    public Object getOrgin(String key) {
        return key == null ? null : this.redisTemplate.opsForValue().get((Object)key);
    }

    public boolean set(String key, Object value) {
        this.redisTemplate.opsForValue().set((Object)key, value);
        return true;
    }

    public boolean set(String key, Object value, Duration timeout) {
        this.redisTemplate.opsForValue().set((Object)key, value, timeout);
        return true;
    }

    public List<Object> lGet(String key, long start, long end) {
        if (end > start) {
            --end;
        }
        return this.redisTemplate.opsForList().range((Object)key, start, end);
    }

    public boolean lSet(String key, List values) {
        ListOperations list = this.redisTemplate.opsForList();
        values.forEach(value -> list.rightPush((Object)key, value));
        return true;
    }

    public Object hGet(String key, String hashKey) {
        return this.redisTemplate.opsForHash().get((Object)key, (Object)hashKey);
    }

    public Map<Object, Object> hentries(String key) {
        return this.redisTemplate.opsForHash().entries((Object)key);
    }

    public void hput(String key, String hashKey, Object value) {
        this.redisTemplate.opsForHash().put((Object)key, (Object)hashKey, value);
    }

    public void hdelete(String key, String[] hashKey) {
        this.redisTemplate.opsForHash().delete((Object)key, (Object[])hashKey);
    }

    public boolean setIfAbsent(String key, Object value, Duration timeout) {
        return this.redisTemplate.opsForValue().setIfAbsent((Object)key, value, timeout);
    }

    public boolean setIfAbsent(String key, Object value) {
        return this.redisTemplate.opsForValue().setIfAbsent((Object)key, value);
    }

    public Set<String> getKeysFuzzy(String fuzzyKey) {
        return this.redisTemplate.keys((Object)fuzzyKey);
    }
}

