/*
 * Decompiled with CFR 0.152.
 */
package cn.com.yusys.yusp.front.common.trade;

import cn.com.yusys.yusp.front.common.Entity.YuinRequestDto;
import cn.com.yusys.yusp.front.common.Entity.YuinResultDto;
import cn.com.yusys.yusp.front.common.constant.JavaDict;
import cn.com.yusys.yusp.front.common.constant.YuinResult;
import cn.com.yusys.yusp.front.common.repo.FiledMapCompent;
import cn.com.yusys.yusp.front.common.trade.IPayTradeMethod;
import cn.com.yusys.yusp.front.common.util.StringUtilEx;
import cn.com.yusys.yusp.front.common.util.YuinBeanUtil;
import cn.com.yusys.yusp.front.common.util.YuinLogUtils;
import java.util.Date;
import java.util.Map;
import java.util.regex.Pattern;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.web.context.request.RequestContextHolder;
import org.springframework.web.context.request.ServletRequestAttributes;

@Component
public class PayChnlRequestService {
    @Autowired
    private FiledMapCompent filedMapCompent;

    @Transactional
    public <T> YuinResultDto tradeExec(YuinRequestDto<T> requestDto, IPayTradeMethod iPayTradeMethod) {
        Map<String, Object> request = YuinBeanUtil.convertRequest(requestDto);
        long tradestarttime = new Date().getTime();
        ServletRequestAttributes servletRequestAttributes = (ServletRequestAttributes)RequestContextHolder.getRequestAttributes();
        HttpServletRequest requestr = servletRequestAttributes.getRequest();
        HttpServletResponse response = servletRequestAttributes.getResponse();
        String asynKey = requestr.getHeader("asyncKey");
        String asynReply = requestr.getHeader("asyncReply");
        request.put("asynckey", asynKey);
        request.put("asyncreply", asynReply);
        YuinLogUtils.getInst(this).info(request.get("tradecode").toString() + "|asyncKey\uff1a" + asynKey);
        YuinLogUtils.getInst(this).info(request.get("tradecode").toString() + "|asyncReply\uff1a" + asynReply);
        if (iPayTradeMethod == null) {
            return YuinResultDto.error("\u83b7\u53d6\u6784\u9020\u5668\u5f02\u5e38");
        }
        YuinResult result = null;
        String curTradeFlowStep = "00";
        try {
            YuinLogUtils.getInst(this).info(request.get("tradecode").toString() + "\u4ea4\u6613\u521d\u59cb\u5316\u5f00\u59cb");
            result = iPayTradeMethod.initTradeInfoHandler(request);
            String logPrefix = request.get("logPrefix").toString();
            YuinLogUtils.getInst(this).info(logPrefix + "\u4ea4\u6613\u521d\u59cb\u5316\u5b8c\u6bd5");
            if (result.isSuccess()) {
                YuinLogUtils.getInst(this).info(logPrefix + "\u6570\u636e\u767b\u8bb0\u5f00\u59cb");
                request.put("curTradeFlowStep", "10");
                result = iPayTradeMethod.dataProcHandler(request);
                if (result.isSuccess()) {
                    YuinLogUtils.getInst(this).info(logPrefix + "\u6570\u636e\u767b\u8bb0\u5b8c\u6bd5");
                } else {
                    YuinLogUtils.getInst(this).info(logPrefix + "\u6570\u636e\u767b\u8bb0\u5f02\u5e38");
                }
            }
            if (result.isSuccess()) {
                YuinLogUtils.getInst(this).info(logPrefix + "\u4e1a\u52a1\u68c0\u67e5\u5f00\u59cb");
                request.put("curTradeFlowStep", "10");
                result = iPayTradeMethod.tradechekHandler(request);
                if (result.isSuccess()) {
                    YuinLogUtils.getInst(this).info(logPrefix + "\u4e1a\u52a1\u68c0\u67e5\u5b8c\u6bd5");
                } else {
                    YuinLogUtils.getInst(this).info(logPrefix + "\u4e1a\u52a1\u68c0\u67e5\u5f02\u5e38");
                }
            }
            if (result.isSuccess()) {
                YuinLogUtils.getInst(this).info(logPrefix + "\u667a\u80fd\u8def\u7531\u5f00\u59cb");
                request.put("curTradeFlowStep", "10");
                result = iPayTradeMethod.smartRouteHandler(request);
                if (result.isSuccess()) {
                    YuinLogUtils.getInst(this).info(logPrefix + "\u667a\u80fd\u8def\u7531\u5b8c\u6bd5");
                } else {
                    YuinLogUtils.getInst(this).info(logPrefix + "\u667a\u80fd\u8def\u7531\u5f02\u5e38");
                }
            }
            if (result.isSuccess()) {
                YuinLogUtils.getInst(this).info(logPrefix + "\u7279\u6b8a\u68c0\u67e5\u5f00\u59cb");
                request.put("curTradeFlowStep", "10");
                result = iPayTradeMethod.specialChekHandler(request);
                if (result.isSuccess()) {
                    YuinLogUtils.getInst(this).info(logPrefix + "\u7279\u6b8a\u68c0\u67e5\u5b8c\u6bd5");
                } else {
                    YuinLogUtils.getInst(this).info(logPrefix + "\u7279\u6b8a\u68c0\u67e5\u5f02\u5e38");
                }
            }
            if (result.isSuccess()) {
                YuinLogUtils.getInst(this).info(logPrefix + "\u6838\u5fc3\u8d26\u52a1\u5904\u7406\u5f00\u59cb");
                if (!"0".equals(StringUtilEx.getMapValue(request, "__acctflag__").toString())) {
                    request.put("curTradeFlowStep", "20");
                    result = iPayTradeMethod.coreAccountsHandler(request);
                    if (result.isSuccess()) {
                        YuinLogUtils.getInst(this).info(logPrefix + "\u6838\u5fc3\u8d26\u52a1\u5904\u7406\u5b8c\u6bd5");
                    } else {
                        YuinLogUtils.getInst(this).info(logPrefix + "\u6838\u5fc3\u8d26\u52a1\u5904\u7406\u5f02\u5e38");
                    }
                } else {
                    YuinLogUtils.getInst(this).info(logPrefix + "\u6b64\u4ea4\u6613\u65e0\u9700\u6838\u5fc3\u901a\u8baf");
                }
                YuinLogUtils.getInst(this).info(logPrefix + "\u6838\u5fc3\u8d26\u52a1\u5904\u7406\u7ed3\u675f");
            }
            if (result.isSuccess()) {
                YuinLogUtils.getInst(this).info(logPrefix + "\u652f\u4ed8\u7f51\u5173\u53d1\u9001\u5f00\u59cb");
                if ("1".equals(StringUtilEx.getMapValue(request, "__corpsendflag__").toString())) {
                    request.put("curTradeFlowStep", "30");
                    result = iPayTradeMethod.payGatewayHandler(request);
                    if (result.isSuccess()) {
                        YuinLogUtils.getInst(this).info(logPrefix + "\u652f\u4ed8\u7f51\u5173\u53d1\u9001\u5b8c\u6bd5");
                    } else {
                        YuinLogUtils.getInst(this).info(logPrefix + "\u652f\u4ed8\u7f51\u5173\u53d1\u9001\u5f02\u5e38");
                    }
                } else {
                    YuinLogUtils.getInst(this).info(logPrefix + "\u6b64\u4ea4\u6613\u65e0\u9700\u652f\u4ed8\u7f51\u5173\u53d1\u9001");
                }
            }
            curTradeFlowStep = request.get("curTradeFlowStep").toString();
            if (!result.isSuccess()) {
                request.put("errcode", result.getErrorCode());
                request.put("errmsg", result.getErrorMsg());
                iPayTradeMethod.exceptHandler(request, curTradeFlowStep, result);
            } else {
                if (!request.containsKey("errcode")) {
                    request.put("errcode", "000000");
                }
                if (!request.containsKey("errmsg")) {
                    request.put("errmsg", "\u6210\u529f");
                }
                if (request.getOrDefault("__tradecontrol__", "0").toString().substring(0, 1).equals("1")) {
                    if (StringUtils.isNotBlank((String)asynKey) && Pattern.matches("[0-9A-Za-z]+", asynKey)) {
                        response.setHeader("asyncKey", asynKey);
                    }
                    if (StringUtils.isNotBlank((String)asynReply) && Pattern.matches("[0-9A-Za-z]+", asynReply)) {
                        response.setHeader("asyncReply", asynReply);
                    }
                }
            }
            YuinLogUtils.getInst(this).info(logPrefix + "\u516c\u5171\u5e94\u7b54\u4fe1\u606f\u83b7\u53d6\u5f00\u59cb");
            iPayTradeMethod.endProcHandler(request);
            YuinLogUtils.getInst(this).info(logPrefix + "\u516c\u5171\u5e94\u7b54\u4fe1\u606f\u83b7\u53d6\u7ed3\u675f");
            YuinLogUtils.getInst(this).info(logPrefix + "\u6e20\u9053\u5e94\u7b54\u62a5\u6587\u6620\u5c04\u5f00\u59cb");
            JavaDict responseHeadData = new JavaDict();
            JavaDict responseBodyData = new JavaDict();
            JavaDict requestD = new JavaDict();
            requestD.setMap(request);
            result = this.filedMapCompent.B_Fld_MsgMapHD(requestD, responseHeadData, responseBodyData, request.get("sysid").toString(), request.get("appid").toString(), request.get("tradecode").toString(), "BAP->CHL", "1", "PUB");
            YuinLogUtils.getInst(this).info(logPrefix + "\u6e20\u9053\u5e94\u7b54\u62a5\u6587\u6620\u5c04\u7ed3\u675f");
            if (!result.isSuccess()) {
                YuinLogUtils.getInst(this).error(request.getOrDefault("errmsg", "\u5e94\u7b54msgmap\u5f02\u5e38").toString(), new Object[0]);
                return YuinResultDto.failure(request.getOrDefault("errcode", "E0001").toString(), request.getOrDefault("errmsg", "\u5e94\u7b54msgmap\u5f02\u5e38").toString(), request.getOrDefault("workdate", "").toString(), request.getOrDefault("workseqid", "").toString());
            }
            long tradeendtime = new Date().getTime();
            long tradetime = tradeendtime - tradestarttime;
            YuinLogUtils.getInst(this).info(logPrefix + "\u4ea4\u6613\u7ed3\u675f\uff0c\u7528\u65f6\uff1a" + tradetime + "ms");
            return YuinResultDto.sucess(responseHeadData, responseBodyData.get());
        }
        catch (Exception e) {
            e.printStackTrace();
            YuinLogUtils.getInst(this).error("\u5f53\u524d\u6d41\u7a0b\u6b65\u9aa4:" + curTradeFlowStep + "\u6267\u884c\u5f02\u5e38:" + request.getOrDefault("errmsg", "\u5f02\u5e38\u629b\u51fa").toString(), e, new Object[0]);
            iPayTradeMethod.exceptHandler(request, curTradeFlowStep, result);
            return YuinResultDto.failure("E0001", "\u5f53\u524d\u6d41\u7a0b\u6b65\u9aa4:" + curTradeFlowStep + "\u6267\u884c\u5f02\u5e38:" + request.getOrDefault("errmsg", "\u5f02\u5e38\u629b\u51fa").toString(), request.getOrDefault("workdate", "").toString(), request.getOrDefault("workseqid", "").toString());
        }
    }
}

