/*
 * Decompiled with CFR 0.152.
 */
package cn.com.yusys.yusp.front.common.repo;

import cn.com.yusys.yusp.front.common.Entity.YuinResultDto;
import cn.com.yusys.yusp.front.common.repo.ITradeStatusMethod;
import cn.com.yusys.yusp.front.parm.application.service.BaseService;
import cn.com.yusys.yusp.front.parm.application.service.UpDBusiCtlService;
import cn.com.yusys.yusp.front.parm.application.service.UpDDbactionService;
import cn.com.yusys.yusp.front.parm.application.service.UpDDbeventService;
import cn.com.yusys.yusp.front.parm.application.service.UpSStsctlService;
import cn.com.yusys.yusp.front.parm.dao.po.DynamicSql;
import cn.com.yusys.yusp.front.parm.dao.po.UpDDbactionPo;
import cn.com.yusys.yusp.front.parm.dao.po.UpDDbeventPo;
import cn.com.yusys.yusp.front.parm.domain.vo.UpDBusiCtlQueryVo;
import cn.com.yusys.yusp.front.parm.domain.vo.UpDDbactionQueryVo;
import cn.com.yusys.yusp.front.parm.domain.vo.UpDDbeventQueryVo;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.commons.beanutils.BeanUtils;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.ApplicationContext;
import org.springframework.stereotype.Component;
import org.springframework.transaction.annotation.Propagation;
import org.springframework.transaction.annotation.Transactional;

@Component
@Transactional
public class TradeStatusRepo {
    private static final Logger logger = LoggerFactory.getLogger(TradeStatusRepo.class);
    @Autowired
    private UpDBusiCtlService upDBusiCtlService;
    @Autowired
    private UpDDbactionService upDDbactionService;
    @Autowired
    private UpDDbeventService upDDbeventService;
    @Autowired
    private UpSStsctlService upSStsctlService;
    @Autowired
    private BaseService baseService;
    @Autowired
    private ApplicationContext applicationContext;
    private String status = "0";
    private String resultStatus = "200";

    @Transactional
    public <T> YuinResultDto updateTradeStep(Map<String, Object> context, String lasttradebusistep, String lastbusistatus) throws Exception {
        String relatecorpstatus;
        String relatebusistatus;
        String relatetradebusistep;
        String corpstatus;
        String busistatusup;
        ConcurrentHashMap<String, Object> data = new ConcurrentHashMap<String, Object>();
        String sysid = String.valueOf(context.get("sysid"));
        String appid = String.valueOf(context.get("appid"));
        String tradecode = String.valueOf(context.get("tradecode"));
        if (StringUtils.isEmpty((String)sysid) || StringUtils.isEmpty((String)tradecode)) {
            logger.info("\u7cfb\u7edf\u7f16\u53f7\u6216\u8005\u4ea4\u6613\u7801\u4e3a\u7a7a");
            return YuinResultDto.failure("500", "\u7cfb\u7edf\u7f16\u53f7\u6216\u8005\u4ea4\u6613\u7801\u4e3a\u7a7a");
        }
        String stepaddflag = String.valueOf(context.get("stepaddflag"));
        if (StringUtils.isEmpty((String)stepaddflag)) {
            stepaddflag = "0";
        }
        data.put("stepaddflag", stepaddflag);
        UpDBusiCtlQueryVo upDBusiCtlQueryVo = new UpDBusiCtlQueryVo();
        upDBusiCtlQueryVo.setSysid(sysid);
        upDBusiCtlQueryVo.setTradecode(tradecode);
        upDBusiCtlQueryVo.setLasttradebusistep(lasttradebusistep);
        upDBusiCtlQueryVo.setLastbusistatus(lastbusistatus);
        UpDBusiCtlQueryVo busiCtlQueryVo = this.upDBusiCtlService.detail(upDBusiCtlQueryVo);
        if (busiCtlQueryVo == null) {
            logger.info("\u67e5\u65e0\u914d\u7f6e\u4fe1\u606f");
            return YuinResultDto.failure("500", "\u67e5\u65e0\u914d\u7f6e\u4fe1\u606f");
        }
        String tradebusistepup = busiCtlQueryVo.getTradebusistep();
        if (!this.status.equals(tradebusistepup)) {
            data.put("tradebusistepup", tradebusistepup);
            context.put("tradebusistepup", tradebusistepup);
        }
        if (!this.status.equals(busistatusup = busiCtlQueryVo.getBusistatus())) {
            data.put("busistatusup", busistatusup);
            context.put("busistatusup", busistatusup);
        }
        if (!this.status.equals(corpstatus = busiCtlQueryVo.getCorpstatus())) {
            data.put("corpstatus", corpstatus);
            context.put("corpstatus", corpstatus);
        }
        if (!this.status.equals(relatetradebusistep = busiCtlQueryVo.getRelatetradebusistep())) {
            data.put("relatetradebusistep", relatetradebusistep);
            context.put("relatetradebusistep", relatetradebusistep);
        }
        if (!this.status.equals(relatebusistatus = busiCtlQueryVo.getRelatebusistatus())) {
            data.put("relatebusistatus", relatebusistatus);
            context.put("relatebusistatus", relatebusistatus);
        }
        if (!this.status.equals(relatecorpstatus = busiCtlQueryVo.getRelatecorpstatus())) {
            data.put("relatecorpstatus", relatecorpstatus);
            context.put("relatecorpstatus", relatecorpstatus);
        }
        String dataMapper = busiCtlQueryVo.getDataMapper();
        UpDDbactionQueryVo upDDbactionQueryVo = null;
        YuinResultDto resultDto = null;
        if (StringUtils.isNotEmpty((String)dataMapper) && !this.status.equals(dataMapper)) {
            upDDbactionQueryVo = new UpDDbactionQueryVo();
            upDDbactionQueryVo.setActionkey(dataMapper);
            upDDbactionQueryVo.setOpertype("M");
            UpDDbactionQueryVo actionQueryVo = this.upDDbactionService.detail(upDDbactionQueryVo);
            UpDDbactionPo upDDbactionPo = new UpDDbactionPo();
            BeanUtils.copyProperties((Object)upDDbactionPo, (Object)((Object)actionQueryVo));
            if (actionQueryVo != null) {
                DynamicSql dynamicSql = new DynamicSql();
                dynamicSql.setUpDDbaction(upDDbactionPo);
                dynamicSql.setData(data);
                resultDto = this.baseService.dynamic(dynamicSql);
            }
            if (resultDto != null && this.resultStatus.equals(resultDto.getHead().getResponseCode())) {
                Map resultMap = (Map)resultDto.getBody();
                data.putAll(resultMap);
            }
        }
        String exeBean = busiCtlQueryVo.getExeBean();
        String eventid = busiCtlQueryVo.getEventid();
        if (StringUtils.isNotEmpty((String)eventid)) {
            resultDto = this.operEvent(data, sysid, appid, eventid);
        } else {
            ITradeStatusMethod classInstance = (ITradeStatusMethod)this.applicationContext.getBean(exeBean);
            resultDto = classInstance.updateStatus(context, lasttradebusistep, lastbusistatus);
        }
        return resultDto;
    }

    @Transactional(propagation=Propagation.REQUIRES_NEW)
    public YuinResultDto operEvent(Map<String, Object> data, String sysid, String appid, String eventid) throws Exception {
        try {
            this.beforeCheck(data, sysid, appid, eventid);
        }
        catch (Exception e) {
            logger.info(e.getMessage());
            return YuinResultDto.failure("500", e.getMessage());
        }
        UpDDbeventQueryVo upDDbeventQueryVo = new UpDDbeventQueryVo();
        upDDbeventQueryVo.setSysid(sysid);
        upDDbeventQueryVo.setAppid(appid);
        upDDbeventQueryVo.setEventid(eventid);
        List<UpDDbeventPo> eventVoLis = this.upDDbeventService.list(upDDbeventQueryVo);
        if (CollectionUtils.isEmpty(eventVoLis)) {
            logger.info("\u6570\u636e\u4e8b\u52a1\u914d\u7f6e\u4e3a\u7a7a");
            return YuinResultDto.failure("500", "\u6570\u636e\u4e8b\u52a1\u914d\u7f6e\u4e3a\u7a7a");
        }
        String actionkey = "";
        UpDDbactionQueryVo upDDbactionQueryVo = null;
        YuinResultDto resultDto = null;
        for (UpDDbeventPo eventPo : eventVoLis) {
            actionkey = eventPo.getActionkey();
            upDDbactionQueryVo = new UpDDbactionQueryVo();
            upDDbactionQueryVo.setSysid(sysid);
            upDDbactionQueryVo.setActionkey(actionkey);
            UpDDbactionQueryVo actionQueryVo = this.upDDbactionService.detail(upDDbactionQueryVo);
            if (actionQueryVo == null) {
                logger.info("\u6570\u636e\u64cd\u4f5c\u914d\u7f6e\u4e3a\u7a7a");
                return YuinResultDto.failure("500", "\u6570\u636e\u64cd\u4f5c\u914d\u7f6e\u4e3a\u7a7a");
            }
            DynamicSql dynamicSql = new DynamicSql();
            UpDDbactionPo upDDbactionPo = new UpDDbactionPo();
            dynamicSql.setData(data);
            BeanUtils.copyProperties((Object)upDDbactionPo, (Object)((Object)actionQueryVo));
            dynamicSql.setUpDDbaction(upDDbactionPo);
            resultDto = this.baseService.dynamic(dynamicSql);
            if (this.resultStatus.equals(resultDto.getHead().getResponseCode())) continue;
            logger.info("\u66f4\u65b0\u5931\u8d25");
            return YuinResultDto.failure("300", "\u66f4\u65b0\u5931\u8d25");
        }
        return resultDto;
    }

    private void beforeCheck(Map<String, Object> data, String sysid, String appid, String eventid) throws Exception {
        if (null == data) {
            throw new Exception("\u4e0a\u4e0b\u6587\u6570\u636e\u4e0d\u5b58\u5728!");
        }
        if (StringUtils.isEmpty((String)sysid)) {
            throw new Exception("\u7cfb\u7edf\u6807\u8bc6\u4e0d\u80fd\u4e3a\u7a7a!");
        }
        if (StringUtils.isEmpty((String)appid)) {
            throw new Exception("\u5e94\u7528\u6807\u8bc6\u4e0d\u80fd\u4e3a\u7a7a!");
        }
        if (StringUtils.isEmpty((String)eventid)) {
            throw new Exception("\u4e8b\u52a1\u4ee3\u53f7\u4e0d\u80fd\u4e3a\u7a7a!");
        }
    }
}

