/*
 * Decompiled with CFR 0.152.
 */
package cn.com.yusys.yusp.front.common.repo;

import cn.com.yusys.yusp.front.common.constant.YuinResult;
import cn.com.yusys.yusp.front.common.repo.ISysProdOperMethod;
import cn.com.yusys.yusp.front.parm.application.service.UpSPdparamService;
import cn.com.yusys.yusp.front.parm.dao.po.UpSPdparamPo;
import cn.com.yusys.yusp.front.parm.domain.vo.UpSPdparamQueryVo;
import java.util.List;
import java.util.Map;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.ApplicationContext;
import org.springframework.stereotype.Component;
import org.springframework.transaction.annotation.Propagation;
import org.springframework.transaction.annotation.Transactional;

@Component
@Transactional
public class SysProdOperRepo {
    private static final Logger logger = LoggerFactory.getLogger(SysProdOperRepo.class);
    @Autowired
    private UpSPdparamService upSPdparamService;
    @Autowired
    private ApplicationContext applicationContext;

    @Transactional(propagation=Propagation.REQUIRES_NEW)
    public YuinResult operProd(Map<String, Object> data, String sysid, String prodcode, String prodtype) {
        try {
            this.beforeCheck(data, sysid, prodcode, prodtype);
        }
        catch (Exception e) {
            logger.info(e.getMessage());
            return YuinResult.newFailureResult("500", e.getMessage());
        }
        UpSPdparamQueryVo upSPdparamQueryVo = new UpSPdparamQueryVo();
        upSPdparamQueryVo.setSysid(sysid);
        upSPdparamQueryVo.setProdcode(prodcode);
        upSPdparamQueryVo.setProdtype(prodtype);
        upSPdparamQueryVo.setDisable("1");
        List<UpSPdparamPo> prodOperList = this.upSPdparamService.list(upSPdparamQueryVo);
        if (CollectionUtils.isEmpty(prodOperList)) {
            logger.info("\u4ea7\u54c1\u64cd\u4f5c\u914d\u7f6e\u4e3a\u7a7a");
            return YuinResult.newFailureResult("500", "\u4ea7\u54c1\u64cd\u4f5c\u914d\u7f6e\u4e3a\u7a7a");
        }
        Object upDDbactionQueryVo = null;
        YuinResult result = null;
        for (UpSPdparamPo prodOper : prodOperList) {
            String[] colerrmap;
            String exeBean = prodOper.getColfunc();
            ISysProdOperMethod classInstance = (ISysProdOperMethod)this.applicationContext.getBean(exeBean);
            result = classInstance.operProd(data);
            if (result.isSuccess()) continue;
            if (!StringUtils.isNotEmpty((String)prodOper.getColerrmap()) || (colerrmap = prodOper.getColerrmap().split(":")).length != 3) break;
            return YuinResult.newFailureResult(colerrmap[1], colerrmap[2]);
        }
        return result;
    }

    private void beforeCheck(Map<String, Object> data, String sysid, String prodcode, String prodtype) throws Exception {
        if (null == data) {
            throw new Exception("\u4e0a\u4e0b\u6587\u6570\u636e\u4e0d\u5b58\u5728!");
        }
        if (StringUtils.isEmpty((String)sysid)) {
            throw new Exception("\u7cfb\u7edf\u6807\u8bc6\u4e0d\u80fd\u4e3a\u7a7a!");
        }
        if (StringUtils.isEmpty((String)prodcode)) {
            throw new Exception("\u4ea7\u54c1\u7f16\u53f7\u4e0d\u80fd\u4e3a\u7a7a!");
        }
        if (StringUtils.isEmpty((String)prodtype)) {
            throw new Exception("\u64cd\u4f5c\u7c7b\u578b\u4e0d\u80fd\u4e3a\u7a7a!");
        }
    }
}

