/*
 * Decompiled with CFR 0.152.
 */
package cn.com.yusys.yusp.front.common.constant;

import cn.com.yusys.yusp.front.common.util.ExceptionUtils;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

public class YuinResult {
    public static final int STAT_SUCCESS = 1;
    public static final int STAT_FAILURE = 0;
    private int status;
    private String errorCode;
    private String errorMsg;
    private List<?> outputParams;

    public YuinResult() {
        this(1, null, null, null);
    }

    public YuinResult(int status) {
        this(status, null, null, null);
    }

    public YuinResult(int status, String errorCode, String errorMsg) {
        this(status, errorCode, errorMsg, null);
    }

    public YuinResult(int status, String errorCode, Throwable e) {
        this(status, errorCode, ExceptionUtils.toDetailString(e), null);
    }

    public YuinResult(int status, List<?> outputParams) {
        this(status, null, null, outputParams);
    }

    public YuinResult(int status, String errorCode, String errorMsg, List<?> outputParams) {
        this.status = status;
        this.errorCode = errorCode;
        this.errorMsg = errorMsg;
        this.outputParams = outputParams;
    }

    public static YuinResult newSuccessResult(Object[] outputParams) {
        return new YuinResult(1).setOutputParams(outputParams);
    }

    public static YuinResult newFailureResult(String errorCode, String errorMsg) {
        return new YuinResult(0, errorCode, errorMsg);
    }

    public static YuinResult newFailureResult(String errorCode, Throwable e) {
        return new YuinResult(0, errorCode, e);
    }

    public int getStatus() {
        return this.status;
    }

    public void setStatus(int status) {
        this.status = status;
    }

    public String getErrorCode() {
        return this.errorCode;
    }

    public void setErrorCode(String errorCode) {
        this.errorCode = errorCode;
    }

    public String getErrorMsg() {
        return this.errorMsg;
    }

    public void setErrorMsg(String errorMsg) {
        this.errorMsg = errorMsg;
    }

    public List<?> getOutputParams() {
        return this.outputParams;
    }

    public YuinResult setOutputParams(List<?> outputParams) {
        this.outputParams = outputParams;
        return this;
    }

    public YuinResult setOutputParams(Object[] outputParams) {
        if (outputParams != null) {
            this.outputParams = new ArrayList<Object>(Arrays.asList(outputParams));
        }
        return this;
    }

    public boolean isSuccess() {
        return this.status == 1;
    }
}

