/*
 * Decompiled with CFR 0.152.
 */
package cn.com.yusys.yusp.front.common.constant;

import cn.com.yusys.yusp.commons.util.BeanToMapUtils;
import cn.com.yusys.yusp.front.common.constant.IDict;
import cn.com.yusys.yusp.front.common.constant.JavaList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class JavaDict
implements IDict {
    Map<String, Object> data = new HashMap<String, Object>();

    @Override
    public void set(String key, Object value) {
        this.data.put(key, value);
    }

    @Override
    public Object get(String key) {
        return this.data.get(key);
    }

    @Override
    public Object get(String key, Object defaultValue) {
        if (this.hasKey(key)) {
            return this.data.get(key);
        }
        return defaultValue;
    }

    @Override
    public boolean hasKey(String key) {
        return this.data.containsKey(key);
    }

    @Override
    public Object remove(String key) {
        return this.data.remove(key);
    }

    @Override
    public boolean getBoolean(String key) {
        return this.getBoolean(key, false);
    }

    @Override
    public boolean getBoolean(String key, boolean defaultValue) {
        if (this.hasKey(key)) {
            Object value = this.data.get(key);
            if (value instanceof Boolean) {
                return (Boolean)value;
            }
            return "true".equals(String.valueOf(value));
        }
        return defaultValue;
    }

    @Override
    public int getInt(String key) {
        return this.getInt(key, 0);
    }

    @Override
    public int getInt(String key, int defaultValue) {
        if (this.hasKey(key)) {
            Object value = this.data.get(key);
            if (value instanceof Integer) {
                return (Integer)value;
            }
            return Integer.parseInt(String.valueOf(value));
        }
        return defaultValue;
    }

    @Override
    public long getLong(String key) {
        return this.getLong(key, 0L);
    }

    @Override
    public long getLong(String key, long defaultValue) {
        if (this.hasKey(key)) {
            Object value = this.data.get(key);
            if (value instanceof Integer) {
                return (Long)value;
            }
            return Long.parseLong(String.valueOf(value));
        }
        return defaultValue;
    }

    @Override
    public double getDouble(String key) {
        return this.getDouble(key, 0.0);
    }

    @Override
    public double getDouble(String key, double defaultValue) {
        if (this.hasKey(key)) {
            Object value = this.data.get(key);
            if (value instanceof Integer) {
                return (Double)value;
            }
            return Double.parseDouble(String.valueOf(value));
        }
        return defaultValue;
    }

    @Override
    public float getFloat(String key) {
        return this.getFloat(key, 0.0f);
    }

    @Override
    public float getFloat(String key, float defaultValue) {
        if (this.hasKey(key)) {
            Object value = this.data.get(key);
            if (value instanceof Integer) {
                return ((Float)value).floatValue();
            }
            return Float.parseFloat(String.valueOf(value));
        }
        return defaultValue;
    }

    @Override
    public String getString(String key) {
        return this.getString(key, null);
    }

    @Override
    public String getString(String key, String defaultValue) {
        if (this.hasKey(key)) {
            Object value = this.data.get(key);
            if (value instanceof String) {
                return (String)value;
            }
            if (value == null) {
                return null;
            }
            return String.valueOf(value);
        }
        return defaultValue;
    }

    public String toString() {
        if (this.data == null || this.data.isEmpty()) {
            return "{}";
        }
        Iterator<Map.Entry<String, Object>> i = this.data.entrySet().iterator();
        StringBuilder sb = new StringBuilder();
        sb.append('{');
        String keyString = null;
        String valueString = null;
        while (true) {
            Map.Entry<String, Object> e = i.next();
            String key = e.getKey();
            Object value = e.getValue();
            keyString = key == this ? "(this Map)" : (key instanceof String || key instanceof byte[] ? "\"" + key + "\"" : String.valueOf(key));
            sb.append(keyString);
            sb.append(':');
            valueString = value == this ? "(this Map)" : (value instanceof String || value instanceof byte[] ? "\"" + value + "\"" : String.valueOf(value));
            sb.append(valueString);
            if (!i.hasNext()) {
                return sb.append('}').toString();
            }
            sb.append(',').append(' ');
        }
    }

    public void setMap(Map<String, Object> map) {
        this.data.putAll(map);
    }

    @Override
    public void set(IDict dict) {
        this.data.putAll(dict.get());
    }

    @Override
    public Map<String, Object> get() {
        Map<String, Object> map = this.data;
        if (map != null) {
            Set<String> set = map.keySet();
            for (String str : set) {
                if (!(map.get(str) instanceof List)) continue;
                JavaList list = new JavaList(new Object[0]);
                for (Object obj : (List)map.get(str)) {
                    if (obj instanceof JavaDict) {
                        list.add(((JavaDict)obj).get());
                        continue;
                    }
                    list.add(BeanToMapUtils.beanToMap(obj));
                }
                map.put(str, list);
            }
        }
        return this.data;
    }

    public JavaDict getDict(String key) {
        return (JavaDict)this.data.get(key);
    }

    public JavaList getList(String key) {
        return (JavaList)this.data.get(key);
    }

    public Set<String> keySet() {
        return this.data.keySet();
    }

    public void clear() {
        this.data.clear();
    }
}

