/*
 * Decompiled with CFR 0.152.
 */
package cn.com.yusys.yusp.front.common.annotation;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONException;
import com.alibaba.fastjson.JSONObject;
import java.util.HashMap;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.lang3.StringUtils;
import org.aspectj.lang.ProceedingJoinPoint;
import org.aspectj.lang.annotation.Around;
import org.aspectj.lang.annotation.Aspect;
import org.aspectj.lang.annotation.Pointcut;
import org.aspectj.lang.reflect.MethodSignature;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

@Aspect
@Component
public class SqlInjectionAspect {
    private Logger logger = LoggerFactory.getLogger(this.getClass());

    @Pointcut(value="@annotation(cn.com.yusys.yusp.front.common.annotation.SqlInjection)")
    public void sqlInjection() {
    }

    @Around(value="sqlInjection()")
    public Object round(ProceedingJoinPoint joinPoint) throws Throwable {
        this.logger.info("sql\u6ce8\u5165\u68c0\u67e5\u73af\u7ed5\u901a\u77e5\u5f00\u59cb........");
        this.logger.info(joinPoint.getSignature().getName());
        Object[] args = joinPoint.getArgs();
        MethodSignature methodSignature = (MethodSignature)joinPoint.getSignature();
        String[] parameterNames = methodSignature.getParameterNames();
        for (int i = 0; i < args.length; ++i) {
            if (!SqlInjectionAspect.containsSqlInjection(JSON.toJSONString((Object)args[i]))) continue;
            HashMap<String, String> sqlInjectionMap = new HashMap<String, String>();
            SqlInjectionAspect.getSqlInjection("\u65b9\u6cd5\u53c2\u6570" + i, JSON.toJSONString((Object)args[i]), sqlInjectionMap);
            for (String a : sqlInjectionMap.keySet()) {
                this.logger.info(a + ":" + (String)sqlInjectionMap.get(a));
            }
            this.logger.info("\u4ee5\u4e0a\u5b57\u6bb5\u5b58\u5728\u975e\u6cd5\u5165\u53c2........");
            this.logger.info("sql\u6ce8\u5165\u68c0\u67e5\u73af\u7ed5\u901a\u77e5\u7ed3\u675f........");
            throw new Exception("\u5b58\u5728\u975e\u6cd5\u53c2\u6570,\u8bf7\u89c4\u8303\u63a5\u53e3\u5165\u53c2");
        }
        this.logger.info("sql\u6ce8\u5165\u68c0\u67e5\u73af\u7ed5\u901a\u77e5\u7ed3\u675f........");
        return joinPoint.proceed();
    }

    public static boolean containsSqlInjection(Object obj) {
        if (null == obj || StringUtils.isEmpty((CharSequence)String.valueOf(obj))) {
            return false;
        }
        Pattern pattern = Pattern.compile("\\b(alert|and|exec|insert|select|drop|grant|alter|delete|update|count|chr|mid|master|truncate|char|declare|or)\\b|(\\*|'|%)");
        Matcher matcher = pattern.matcher(obj.toString());
        return matcher.find();
    }

    public static void getSqlInjection(String key, String jsonStr, Map<String, String> map) {
        if (StringUtils.isEmpty((CharSequence)jsonStr)) {
            return;
        }
        int type = SqlInjectionAspect.testIsArrayORObject(jsonStr);
        if (type == 1) {
            JSONObject jsonObject = JSONObject.parseObject((String)jsonStr);
            for (String str : jsonObject.keySet()) {
                String value = jsonObject.getString(str);
                if (!SqlInjectionAspect.containsSqlInjection(value)) continue;
                SqlInjectionAspect.getSqlInjection(key + "." + str, value, map);
            }
        } else if (type == 2) {
            if (!jsonStr.equals("null")) {
                JSONArray jsonArray = JSONObject.parseArray((String)jsonStr);
                for (int i = 0; i < jsonArray.size(); ++i) {
                    JSONObject jsonObject = jsonArray.getJSONObject(i);
                    for (String str : jsonObject.keySet()) {
                        String value = jsonObject.getString(str);
                        if (!SqlInjectionAspect.containsSqlInjection(value)) continue;
                        SqlInjectionAspect.getSqlInjection(key + "." + str, value, map);
                    }
                }
            }
        } else {
            map.put(key, jsonStr);
        }
    }

    public static int testIsArrayORObject(String sJSON) {
        try {
            JSONArray array = JSONObject.parseArray((String)sJSON);
            return 2;
        }
        catch (JSONException e) {
            try {
                JSONObject object = JSONObject.parseObject((String)sJSON);
                return 1;
            }
            catch (JSONException e2) {
                return 0;
            }
        }
    }
}

