/*
 * Decompiled with CFR 0.152.
 */
package cn.com.yusys.yusp.registry.middleware.service;

import cn.com.yusys.yusp.registry.host.exception.DashboardFileException;
import cn.com.yusys.yusp.registry.host.exception.DashboardSessionException;
import cn.com.yusys.yusp.registry.middleware.domain.MiddleWareInfo;
import cn.com.yusys.yusp.registry.middleware.repository.MiddleWareInfoRepository;
import cn.com.yusys.yusp.registry.middleware.service.DeployTaskService;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class MiddleWareInfoService {
    @Autowired
    private MiddleWareInfoRepository middleWareInfoRepository;
    @Autowired
    private DeployTaskService deployTaskService;

    public void addInfo(MiddleWareInfo info) throws DashboardFileException {
        this.middleWareInfoRepository.addInfo(info);
    }

    public void delInfo(String ids) throws DashboardFileException {
        this.middleWareInfoRepository.delInfo(ids);
    }

    public List<MiddleWareInfo> getInfoListByUserId(String userId) throws DashboardSessionException {
        List<MiddleWareInfo> list = this.middleWareInfoRepository.getInfoListByUserId(userId);
        for (MiddleWareInfo info : list) {
            boolean flag = this.deployTaskService.getMiddleWareStatus(info.getMiddleWareName(), info.getHostName());
            if (flag) {
                info.setStatus(1);
                continue;
            }
            info.setStatus(-1);
        }
        return list;
    }

    public List<MiddleWareInfo> getInfoListByids(String ids) {
        ArrayList<MiddleWareInfo> list = new ArrayList<MiddleWareInfo>();
        for (String id : Arrays.asList(ids.split(","))) {
            list.add(this.middleWareInfoRepository.getInfoByid(ids));
        }
        return list;
    }

    public MiddleWareInfo getInfoByid(String id) {
        return this.middleWareInfoRepository.getInfoByid(id);
    }
}

