/*
 * Decompiled with CFR 0.152.
 */
package cn.com.yusys.yusp.registry.middleware.resource;

import cn.com.yusys.yusp.registry.host.common.ResultDto;
import cn.com.yusys.yusp.registry.middleware.domain.MiddleWareInfo;
import cn.com.yusys.yusp.registry.middleware.service.MiddleWareInfoService;
import java.util.List;
import javax.validation.Valid;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/api/middlewareinfo"})
public class MiddleWareInfoResource {
    private static final Logger logger = LoggerFactory.getLogger(MiddleWareInfoResource.class);
    @Autowired
    private MiddleWareInfoService middleWareInfoService;

    @GetMapping(value={"/list"})
    public ResultDto<List<MiddleWareInfo>> getDeployTaskList(@RequestParam(value="userId", required=false) String userId) {
        List<MiddleWareInfo> list = null;
        try {
            list = this.middleWareInfoService.getInfoListByUserId(userId);
        }
        catch (Exception e) {
            e.printStackTrace();
            return new ResultDto(-1, 0L, e.getMessage(), null);
        }
        return new ResultDto((long)list.size(), list);
    }

    @GetMapping(value={"/listByIds"})
    public ResultDto<List<MiddleWareInfo>> getInfoListByIds(@RequestParam(value="ids", required=true) String ids) {
        List<MiddleWareInfo> list = null;
        try {
            list = this.middleWareInfoService.getInfoListByids(ids);
        }
        catch (Exception e) {
            e.printStackTrace();
            return new ResultDto(-1, 0L, e.getMessage(), null);
        }
        return new ResultDto((long)list.size(), list);
    }

    @PostMapping(value={"/"})
    public ResultDto<String> updateDeployTask(@Valid MiddleWareInfo info) {
        try {
            this.middleWareInfoService.addInfo(info);
        }
        catch (Exception e) {
            e.printStackTrace();
            return new ResultDto(-1, 0L, e.getMessage(), null);
        }
        return new ResultDto((Object)"success");
    }

    @GetMapping(value={"/delete"})
    public ResultDto<String> delDeployTask(@RequestParam(value="ids") String ids) {
        try {
            this.middleWareInfoService.delInfo(ids);
        }
        catch (Exception e) {
            e.printStackTrace();
            return new ResultDto(-1, 0L, e.getMessage(), null);
        }
        return new ResultDto((Object)"success");
    }
}

