/*
 * Decompiled with CFR 0.152.
 */
package cn.com.yusys.yusp.registry.middleware.resource;

import cn.com.yusys.yusp.registry.host.common.ResultDto;
import cn.com.yusys.yusp.registry.middleware.domain.DeployTask;
import cn.com.yusys.yusp.registry.middleware.service.DeployTaskService;
import java.util.List;
import java.util.UUID;
import javax.validation.Valid;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/api/deploytask"})
public class DeployTakResource {
    private static final Logger logger = LoggerFactory.getLogger(DeployTakResource.class);
    @Autowired
    private DeployTaskService service;

    @GetMapping(value={"/list"})
    public ResultDto<List<DeployTask>> getDeployTaskList(@RequestParam(value="userId", required=false) String userId) {
        List<DeployTask> list = null;
        try {
            list = this.service.getDeployTaskList(userId);
        }
        catch (Exception e) {
            e.printStackTrace();
            return new ResultDto(-1, 0L, e.getMessage(), null);
        }
        return new ResultDto((long)list.size(), list);
    }

    @GetMapping(value={"/successfullist"})
    public ResultDto<List<DeployTask>> getDeployTaskSuccessfulList(@RequestParam(value="userId", required=false) String userId) {
        List<DeployTask> list = null;
        try {
            list = this.service.getDeployTaskSuccessfulList(userId);
        }
        catch (Exception e) {
            e.printStackTrace();
            return new ResultDto(-1, 0L, e.getMessage(), null);
        }
        return new ResultDto((long)list.size(), list);
    }

    @GetMapping(value={"/failedlist"})
    public ResultDto<List<DeployTask>> getDeployTaskFailedList(@RequestParam(value="userId", required=false) String userId) {
        List<DeployTask> list = null;
        try {
            list = this.service.getDeployTaskFailedList(userId);
        }
        catch (Exception e) {
            e.printStackTrace();
            return new ResultDto(-1, 0L, e.getMessage(), null);
        }
        return new ResultDto((long)list.size(), list);
    }

    @GetMapping(value={"/notfailedlist"})
    public ResultDto<List<DeployTask>> getDeployTaskNotFailedList(@RequestParam(value="userId", required=false) String userId) {
        List<DeployTask> list = null;
        try {
            list = this.service.getDeployTaskNotFailList(userId);
        }
        catch (Exception e) {
            e.printStackTrace();
            return new ResultDto(-1, 0L, e.getMessage(), null);
        }
        return new ResultDto((long)list.size(), list);
    }

    @GetMapping(value={"/listByIds"})
    public ResultDto<List<DeployTask>> getDeployTaskListByIds(@RequestParam(value="ids", required=true) String ids) {
        List<DeployTask> list = null;
        try {
            list = this.service.getDeployTaskListByIds(ids);
        }
        catch (Exception e) {
            e.printStackTrace();
            return new ResultDto(-1, 0L, e.getMessage(), null);
        }
        return new ResultDto((long)list.size(), list);
    }

    @PostMapping(value={"/"})
    public ResultDto<String> addDeployTask(@Valid DeployTask deployTask) {
        if (deployTask.getId() == null || deployTask.getId().equals("")) {
            deployTask.setId(UUID.randomUUID().toString());
        }
        try {
            this.service.addDeployTask(deployTask);
        }
        catch (Exception e) {
            e.printStackTrace();
            return new ResultDto(-1, 0L, e.getMessage(), null);
        }
        return new ResultDto((Object)"success");
    }

    @GetMapping(value={"/delete"})
    public ResultDto<String> delDeployTask(@RequestParam(value="ids") String ids) {
        try {
            this.service.delDeployTask(ids);
        }
        catch (Exception e) {
            e.printStackTrace();
            return new ResultDto(-1, 0L, e.getMessage(), null);
        }
        return new ResultDto((Object)"success");
    }

    @PostMapping(value={"/start"})
    public ResultDto<String> start(@RequestParam(value="id") String id, @RequestParam(value="startConfig", required=false, defaultValue="") String startConfig) {
        try {
            this.service.start(id, startConfig);
        }
        catch (Exception e) {
            e.printStackTrace();
            return new ResultDto(-1, 0L, e.getMessage(), null);
        }
        return new ResultDto((Object)"success");
    }

    @PostMapping(value={"/stop"})
    public ResultDto<String> stop(@RequestParam(value="id") String id) {
        try {
            this.service.stop(id);
        }
        catch (Exception e) {
            e.printStackTrace();
            return new ResultDto(-1, 0L, e.getMessage(), null);
        }
        return new ResultDto((Object)"success");
    }
}

